//**********************
// MPL115.h for mbed
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#ifndef MPL115_H_
#define MPL115_H_

#define MPL115_ADDR     0xC0
#define MPL115_Padc_MSB 0x00
#define MPL115_Padc_LSB 0x01
#define MPL115_Tadc_MSB 0x02
#define MPL115_Tadc_LSB 0x03
#define MPL115_a0MSB    0x04
#define MPL115_a0LSB    0x05
#define MPL115_b1MSB    0x06
#define MPL115_b1LSB    0x07
#define MPL115_b2MSB    0x08
#define MPL115_b2LSB    0x09
#define MPL115_c12MSB   0x0A
#define MPL115_c12LSB   0x0B
#define MPL115_CONVERT  0x12

#include "mbed.h"
#include "typedef.h"

class MPL115A2{
public:
    MPL115A2 (PinName sda, PinName scl);
    MPL115A2 (I2C& p_i2c);
    void start();
    short temperature();
    short pressure();
    void init();

protected:
    
    I2C _i2c;
    char buf[8];
    WORD_VAL Padc;
    WORD_VAL Tadc;
    WORD_VAL a0;
    WORD_VAL b1;
    WORD_VAL b2;
    WORD_VAL c12;

};

#endif /* MPL115_H_ */


