//**********************
// MCP3425.h for mbed
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************

#ifndef MCP3425_H_
#define MCP3425_H_

#define MCP3425_ADDR                0xD0

#include "mbed.h"
#include "typedef.h"


typedef union
{
    unsigned char UC;
    struct
    {
        unsigned char G:2;      // 00=1, 01=2, 10=4, 11=8 Gain
        unsigned char S:2;      // 00=12bits, 01=14bits, 10=16bits
        unsigned char OC:1;     // 0=One-shot, 1=Continuous
        unsigned char C:2;      // NA
        unsigned char RDY:1;    // wrinting 1=Initiate, reading 0=Ready
    } bit;
} CONFIG;



class MCP3425{
public:
    MCP3425 (PinName sda, PinName scl);
    MCP3425 (I2C& p_i2c);
    void init();
    short get();

protected:
    
    I2C _i2c;

    CONFIG config;
    WORD_VAL ad;
    char buf[3];

};

#endif /* MCP3425_H_ */



