//**********************
// MCP3425.cpp for mbed
//
// MCP3425 mcp3425(P0_5,P0_4);
// or
// I2C i2c(P0_5,P0_4);
// MCP3425 mcp3425(i2c);
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************

#include "mbed.h"
#include "MCP3425.h"

MCP3425::MCP3425 (PinName sda, PinName scl) : _i2c(sda, scl) {
    init();
}
MCP3425::MCP3425 (I2C& p_i2c) : _i2c(p_i2c) {
    init();
}


short MCP3425::get()
{

    _i2c.read( MCP3425_ADDR, buf, 3);

    ad.byte.HB=buf[0];
    ad.byte.LB=buf[1];
    config.UC=buf[2];
    return ad.S;
 
}


void MCP3425::init()
{

    config.bit.RDY=1;
    config.bit.C=0;
    config.bit.OC=1;
    config.bit.S=2;
    config.bit.G=0;
    // Initiate Continuous 16bits, 15SPS
    buf[0]=config.UC;
    _i2c.write(MCP3425_ADDR, buf, 1);

}

