//**********************
// M24LC64.cpp for mbed
//
// M24LC64 lcd(P0_5,P0_4);
// or
// I2C i2c(P0_5,P0_4);
// M24LC64 lcd(i2c);
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************

#include "mbed.h"
#include "M24LC64.h"

M24LC64::M24LC64 (PinName sda, PinName scl) : _i2c(sda, scl) {
}
M24LC64::M24LC64 (I2C& p_i2c) : _i2c(p_i2c) {
}

void M24LC64::put(unsigned int a, unsigned char b)
{
    adr.Val=a;
    buf[0]=adr.byte.HB;
    buf[1]=adr.byte.LB;
    buf[2]=b;
    _i2c.write(M24LC64_ADDR, buf, 3);
    wait_ms(5);
}


unsigned char M24LC64::get(unsigned int a)
{
    adr.Val=a;
    buf[0]=adr.byte.HB;
    buf[1]=adr.byte.LB;
    _i2c.write(M24LC64_ADDR, buf, 2, true); // no stop, repeated
    _i2c.read( M24LC64_ADDR, buf, 1);
    return buf[0];
}

