//**********************
// IR.h for mbed
//
// (C)Copyright 2014-2015 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************

#ifndef IR_H_
#define IR_H_

#include "mbed.h"
#define IR_LIMITS  64  // bytes buffer = IR_LIMITS x8 bits
#define AEHA 19
#define NEC 22
#define SONY 23

class IR{
public:
    IR (PinName irin, PinName irin);
    void init();

    unsigned char countHigh();
    unsigned char countLow();
    void getIR2();
    void getIR();
    void outON(char n, char t);
    void outOFF(char n, char t);
    void setIR();

    unsigned char buf[IR_LIMITS];  // bytes buffer
    unsigned char mode;     // 1:NEC, 2:AEHA, 3:SONY
    unsigned short bits;    // 32768 bits capable

protected:
    
    DigitalIn _irin;
    DigitalOut _irout;


};


#endif /* IR_H_ */
