//**********************
// HDC1000.h for mbed
//
// (C)Copyright 2015 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************
#ifndef HDC1000_H_
#define HDC1000_H_

#define HDC1000_ADDR            0x80
#define HDC1000_TEMP            0x00
#define HDC1000_HUM             0x01
#define HDC1000_CONFIG          0x02
#define HDC1000_SERIAL0         0xFB
#define HDC1000_SERIAL1         0xFC
#define HDC1000_SERIAL2         0xFD
#define HDC1000_MAMUFUCTUREER   0xFE
#define HDC1000_DEVICE          0xFF

#include "mbed.h"
#include "typedef.h"

class HDC1000{
public:
    HDC1000 (PinName sda, PinName scl);
    HDC1000 (I2C& p_i2c);

    void get();
    unsigned short humidity();
    unsigned short temperature();
    void init();

protected:
    
    I2C _i2c;

    WORD_VAL hum;
    WORD_VAL temp;
    char buf[8];

};

#endif /* HDC1000_H_ */


