//**********************
// HDC1000.cpp for mbed
//
// HDC1000 hdc1000(P0_5,P0_4);
// or
// I2C i2c(P0_5,P0_4);
// HDC1000 hdc1000(i2c);
//
// (C)Copyright 2015 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************

#include "mbed.h"
#include "HDC1000.h"

HDC1000::HDC1000 (PinName sda, PinName scl) : _i2c(sda, scl) {
    init();
}
HDC1000::HDC1000 (I2C& p_i2c) : _i2c(p_i2c) {
    init();
}


void HDC1000::get()
{
    
    // Trigger
    buf[0] = 0x00;  // Pointer
    _i2c.write(HDC1000_ADDR, buf, 1);   // with stop

    // Wait 6.35ms + 6.5ms
    wait_ms(20);

    // get data
    _i2c.read( HDC1000_ADDR, buf, 4);

}

unsigned short HDC1000::humidity()
{

    // get hum
    get();
    hum.byte.HB=buf[2];
    hum.byte.LB=buf[3];
    return hum.Val;
    
}

unsigned short HDC1000::temperature()
{

    // get temp
    get();
    temp.byte.HB=buf[0];
    temp.byte.LB=buf[1];
    return temp.Val;
    
}

void HDC1000::init()
{

    wait_ms(15);

    // Set configuration
    buf[0] = 0x02;  // Pointer
    buf[1] = 0x10;  // High byte
    buf[2] = 0x00;  // Low byte
    _i2c.write(HDC1000_ADDR, buf, 3);
}



