//**********************
// AQM1602.cpp for mbed
//
// AQM1602 lcd(P0_5,P0_4);
// or
// I2C i2c(P0_5,P0_4);
// AQM1602 lcd(i2c);
//
// (C)Copyright 2015 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************

#include "mbed.h"
#include "AQM1602.h"

AQM1602::AQM1602 (PinName sda, PinName scl) : _i2c(sda, scl) {
    init();
}
AQM1602::AQM1602 (I2C& p_i2c) : _i2c(p_i2c) {
    init();
}

void AQM1602::put(unsigned char a, unsigned char b)
{
    buf[0]=a;
    buf[1]=b;
    _i2c.write(AQM1602_ADDR, buf, 2);
}


void AQM1602::get(unsigned char a)
{
    buf[0] = a;
    _i2c.write(AQM1602_ADDR, buf, 1, true); // no stop, repeated
    _i2c.read( AQM1602_ADDR, buf, 1);

}

void AQM1602::cls()
{
    // Clear Display = 0x01
    put(CMD, 0x01);
    // Wait 1.08ms
    wait_ms(2);

}

void AQM1602::locate(int x, int y)
{

    // 16x2
    put(CMD, 0x80 + y*0x40 + x);

}

void AQM1602::print(const char *a)
{

    while(*a != '\0')
    {
        put(DAT, *a);
        a++;
    }

}

void AQM1602::init()
{
    // Wait 40ms
    wait_ms(100);
    // Function set = 0x38
    put(CMD, 0x38);
    // Wait 26.3us
    wait_ms(1);
    // Function set = 0x39
    put(CMD, 0x39);
    // Wait 26.3us
    wait_ms(1);
    // Internal OSC frequency = 0x14
    put(CMD, 0x14);
    // Wait 26.3us
    wait_ms(1);
    // Contrast set = 0x70
    put(CMD, 0x70);
    // Wait 26.3us
    wait_ms(1);
    // Power/ICON/Contrast control = 0x56
    put(CMD, 0x56);
    // Wait 26.3us
    wait_ms(1);
    // Follower control = 0x6C
    put(CMD, 0x6C);
    // Wait 200ms
    wait_ms(200);
    // Function set = 0x38
    put(CMD, 0x38);
    // Wait 26.3us
    wait_ms(1);
    // Display ON/OFF control = 0x0C
    put(CMD, 0x0C);
    // Wait 26.3us
    wait_ms(1);
    // Clear Display = 0x01
    put(CMD, 0x01);
    // Wait 1.08ms
    wait_ms(2);

}



