//**********************
// AQM0802.cpp for mbed
//
// AQM0802 lcd(P0_5,P0_4);
// or
// I2C i2c(P0_5,P0_4);
// AQM0802 lcd(i2c);
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************

#include "mbed.h"
#include "AQM0802.h"

AQM0802::AQM0802 (PinName sda, PinName scl) : _i2c(sda, scl) {
    init();
}
AQM0802::AQM0802 (I2C& p_i2c) : _i2c(p_i2c) {
    init();
}

void AQM0802::put(unsigned char a, unsigned char b)
{
    buf[0]=a;
    buf[1]=b;
    _i2c.write(AQM0802_ADDR, buf, 2);
}


void AQM0802::get(unsigned char a)
{
    buf[0] = a;
    _i2c.write(AQM0802_ADDR, buf, 1, true); // no stop, repeated
    _i2c.read( AQM0802_ADDR, buf, 1);

}

void AQM0802::cls()
{
    // Clear Display = 0x01
    put(CMD, 0x01);
    // Wait 1.08ms
    wait_ms(2);

}

void AQM0802::locate(int x, int y)
{

    // 8x2
    put(CMD, 0x80 + y*0x40 + x);

}

void AQM0802::print(const char *a)
{

    while(*a != '\0')
    {
        put(DAT, *a);
        a++;
    }

}

void AQM0802::init()
{
    // Wait 40ms
    wait_ms(100);
    // Function set = 0x38
    put(CMD, 0x38);
    // Wait 26.3us
    wait_ms(1);
    // Function set = 0x39
    put(CMD, 0x39);
    // Wait 26.3us
    wait_ms(1);
    // Internal OSC frequency = 0x14
    put(CMD, 0x14);
    // Wait 26.3us
    wait_ms(1);
    // Contrast set = 0x70
    put(CMD, 0x70);
    // Wait 26.3us
    wait_ms(1);
    // Power/ICON/Contrast control = 0x56
    put(CMD, 0x56);
    // Wait 26.3us
    wait_ms(1);
    // Follower control = 0x6C
    put(CMD, 0x6C);
    // Wait 200ms
    wait_ms(200);
    // Function set = 0x38
    put(CMD, 0x38);
    // Wait 26.3us
    wait_ms(1);
    // Display ON/OFF control = 0x0C
    put(CMD, 0x0C);
    // Wait 26.3us
    wait_ms(1);
    // Clear Display = 0x01
    put(CMD, 0x01);
    // Wait 1.08ms
    wait_ms(2);

}



