//**********************
// ADT7410.cpp for mbed
//
// ADT7410 temperature(P0_5,P0_4);
// or
// I2C i2c(P0_5,P0_4);
// ADT7410 temperature(i2c);
//
// (C)Copyright 2014 All rights reserved by Y.Onodera
// http://einstlab.web.fc2.com
//**********************

#include "mbed.h"
#include "ADT7410.h"

//#define SPS
#define ONESHOT

ADT7410::ADT7410 (PinName sda, PinName scl) : _i2c(sda, scl) {
    init();
}
ADT7410::ADT7410 (I2C& p_i2c) : _i2c(p_i2c) {
    init();
}

void ADT7410::put(unsigned char a, unsigned char b)
{
    buf[0]=a;
    buf[1]=b;
    _i2c.write(ADT7410_ADDR, buf, 2);
}


void ADT7410::get(unsigned char a)
{
    buf[0] = a;
    _i2c.write(ADT7410_ADDR, buf, 1, false); // no stop, repeated
    _i2c.read( ADT7410_ADDR, buf, 2);

}

short ADT7410::value()
{

#ifdef ONESHOT
    // wakeup
    // set 16bit resolution with one shot mode
    put(ADT7410_CONFIG, 0xA0);
    wait_ms(240);
#endif

    // RDY?
//    do{
//        get(ADT7410_STATUS);
//    }while(buf[0] & 0x80);

    // get temp_high and low
    get(ADT7410_TEMP_H);
    temp.byte.HB=buf[0];
    temp.byte.LB=buf[1];
    return temp.S;
    
    // C = temp.S / 128
    
}

void ADT7410::init()
{
#ifdef SPS
    // set 16bit resolution with 1 sps mode
    put(ADT7410_CONFIG, 0xC0);
#endif
#ifdef ONSHOT
    // set 16bit resolution with one shot mode
    put(ADT7410_CONFIG, 0xA0);
#endif

}


