#include "mbed.h"
#include <algorithm>

PwmOut motor1(p26);
PwmOut motor2(p25);
PwmOut motor3(p24);
PwmOut motor4(p23);
DigitalOut ledRight(LED1);
DigitalOut ledLeft (LED2);
AnalogIn photoRight(p15);
AnalogIn photoLeft (p16);
DigitalIn sw(p9);

#define PERIOD 0.00005

void init()
{
    motor1.period(PERIOD);
    motor2.period(PERIOD);
    motor3.period(PERIOD);
    motor4.period(PERIOD);
    sw.mode(PullUp);
}

void motor(int right, int left)
{
    right = min(max(right, -100), 100);
    left  = min(max(left , -100), 100);
    motor1.pulsewidth(max(-PERIOD * right / 100, 0.0));
    motor2.pulsewidth(max( PERIOD * right / 100, 0.0));
    motor3.pulsewidth(max( PERIOD * left  / 100, 0.0));
    motor4.pulsewidth(max(-PERIOD * left  / 100, 0.0));
}

int main() {
    int run = 0, right, left, forward = 70;
    float error, gain = 70;
    init(); motor(0, 0);
    while(1){
        error = photoRight.read() - photoLeft.read();
        ledRight = (error > 0);
        ledLeft  = (error < 0);
        right = forward + gain * error;
        left  = forward - gain * error;
        if (!sw) { run ^= 1; wait(0.5); }
        if (run) motor(right, left);
        else     motor(0, 0);
        wait(0.01);
    }
}
