#include "test_TMP102.h"

test_TMP102::test_TMP102(PinName sda, PinName scl, char address)
    : i2c_p(new I2C(sda, scl)), i2c(*i2c_p),adr(address)
{
    init();
}
test_TMP102::test_TMP102(I2C &i2c_obj, char address)
    : i2c_p(NULL), i2c(i2c_obj), adr(address)
{
    init();
}

test_TMP102::~test_TMP102()
{
    if(NULL!=i2c_p)
        delete i2c_p;
}

void test_TMP102::init(void)
{
}

float test_TMP102::read(void)
{
    char reg[2]= {0,0};
    i2c.write(adr, 0x00, 1); //Pointer to the temperature register
    i2c.read(adr, reg, 2); // read two bytes data

    // calculate temperature
    int16_t res = ((int8_t)reg[0] << 4) | ((uint8_t)reg[1] >> 4);
    float temp = (float) ((float)res * 0.0625);
    return temp;
}

test_TMP102::operator float(void)
{
    return (read());
}