#include "mbed.h"
#include "BasicWeb.h"
#include "PS2Keyboard.h"

BasicWeb web(p9, p10, p8);      // tx, rx, reset
PS2Keyboard kb(p12, p11);       // clk, data

int main() {

    PS2Keyboard::keyboard_event_t evt_kb;

    web.browser();      // display browser page
    
    // read in keys
    while(1){
        if(kb.processing(&evt_kb)){
            if(evt_kb.length == 1){
                web.newKey(evt_kb.scancode[0]);
            }else if(evt_kb.length == 2){
                web.modKey(evt_kb.scancode[0], evt_kb.scancode[1]);
            }
        }
    }
    
}
