#include "mbed.h"
#include "TFT_4DGL.h"
#include "HTTPClient.h"
#include "EthernetInterface.h"

class BasicWeb{

  public:
    
    BasicWeb(PinName tx, PinName rx, PinName reset);
    void browser();
    void newKey(char scancode);
    void modKey(char scancode1, char scancode2);
    
  private:
    
    EthernetInterface eth;
    HTTPClient http;
    TFT_4DGL vga;
    
    // current string element and its modifiers
    char* str;
    int strSize;
    bool bold;
    bool title;
    int font;
    int color;
    
    char urlStr[100];
    char titleStr[30];
    char text[10240];                            // holds html text web pages
    int urlIndex;
    int lineIndex;                              // current row on screen to print at
    int index;                                  // current index of text
    static const unsigned char table[160];      // PS2 scancode to ASCII table

    void displayUrl();
    void displayPage();
    void parseStr();
    bool applyTag();
    bool compareTag(char* s, char* tag);
    bool extractStr();
    bool printText(char* s);
    void removeRL(char* s, int size);
    void copyStr(char* s1, char* s2, int size);
};
