
#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h" 
#include <stdio.h>
#include <string.h>
#define HTTPD_SERVER_PORT   80
#define HTTPD_MAX_REQ_LENGTH   1024
#define HTTPD_MAX_HDR_LENGTH   255
#define HTTPD_MAX_FNAME_LENGTH   127
#define HTTPD_MAX_DNAME_LENGTH   127
static const char*          mbedIp       = "192.168.11.102";  //IP
static const char*          mbedMask     = "255.255.255.0";  // Mask
static const char*          mbedGateway  = "192.168.11.1";    //Gateway
char buffer[HTTPD_MAX_REQ_LENGTH+1];
char httpHeader[HTTPD_MAX_HDR_LENGTH+1];
char fileName[HTTPD_MAX_FNAME_LENGTH+1];
char dirName[HTTPD_MAX_DNAME_LENGTH+1];
char *uristr;
char *eou;
char *qrystr;
DigitalOut myled(PF_12);
TCPServer server;
TCPSocket client;
SocketAddress client_addr;
SDBlockDevice sd(PC_12,PC_11,PC_10,PC_9,40000000,40000000);
 FATFileSystem fs("sd", &sd);
 Mutex sd_mutex;
void geturistr(char *reqstr,char * uri,int n)
 { int i;
   char * p;
  
   p=uri;
     i=0;
     while(i<n)
     {
        if (*p=='/') i++;
        p++;
     
     }
   while((*p!='/')&&(*p!=0)) 
      *reqstr++=*p++;
    *reqstr=0x00;
    
     }
int getparamName(char *name,char * params)
{ int i=0;
char *p;
char *n;
p=params;
n=name;
   while(*p!='=')
     { 
     *n++=*p++;
     i++;
     }
      *n=0x00;
      i++;
      return i;
} 
int getparamValue(char *value,char * param)
{ int i=0;
char *p;
char *v;
p=param;
v=value;
   while((*p!='&')&&(*p!=0x00))
    { 
     *v++=*p++;
    i++;
    }
      *v=0x00;
      return i;
}        
bool response_File(char * filename,const char *type)
{int n;
  FILE *fp = fopen(filename, "r");
  if (fp==NULL) return false;
if (strcmp(type,"text/css")||strcmp(type,"text/javascript"))
    sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: %s\r\nCache-Control: max-age=2592000, public\r\n\r\n",type);
    else
     sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: %s\r\n",type);
  
            client.send(httpHeader,strlen(httpHeader));
           // sd_mutex.lock();     
           
             n=1024;
             while (n == 1024) {
                n = fread(buffer, sizeof( char ), 1024, fp);
                client.send(buffer, n);
                   }
          fclose(fp);   
        //  sd_mutex.unlock();
        return true;  
  }  
  void getEXT( char *ext,char * fileName)
  {
    char *f;
    char *e;
e=ext;
f=fileName;
while(*f!='.')
    f++;
    f++;
    while(*f!=0x00)
      *e++=*f++;
   *e=0x00;
      }  
     
int main()
{   char fileName[32];
    char reqstr[32];
    char temp[32];
    char ext[8];
    char *params; 
    bool res;  
    printf("Basic HTTP server example\n");
    EthernetInterface eth;
    eth.set_network(mbedIp,mbedMask,mbedGateway);
    eth.connect();
    printf("The target IP address is '%s'\n", eth.get_ip_address());      
    /* Open the server on ethernet stack */
    server.open(&eth);
    
    /* Bind the HTTP port (TCP 80) to the server */
    server.bind(eth.get_ip_address(), 80);
    
    /* Can handle 5 simultaneous connections */
    server.listen(8);
 myled=1;
    while (true) {
        server.accept(&client, &client_addr);
     //   client.set_blocking(true);
        printf("Connection from: %s\r\n", client_addr.get_ip_address());   
     // while (true) {
           int n = client.recv(buffer, sizeof(buffer));
        //    if (n <= 0) break;         
           if (strncmp(buffer, "GET ", 4)==0)
           {
            uristr = buffer + 4;
            eou = strstr(uristr, " ");
            *eou = 0;
           geturistr(reqstr,uristr,1);
           printf("request=%s+\n",uristr);
           if (strcmp(reqstr,"index")==0){     //GET index.html
          // printf("OK\n");
       res=   response_File("/sd/views/index.html","text/html");
             } else
          if  (strcmp(reqstr,"images")==0){   //GET images
                  geturistr(reqstr,uristr,2);
                // printf("image name%s\n",reqstr);
                strcpy(fileName,"/sd/images/");
                strcat(fileName,reqstr);
               // printf("filename=%s\n",fileName);
               getEXT(ext,fileName);
               strcpy(temp,"image/");
               strcat(temp,ext);
           res=      response_File(fileName,temp);
             }else
           if  (strcmp(reqstr,"css")==0){  //GET css
                  geturistr(reqstr,uristr,2);
                strcpy(fileName,"/sd/css/");
                strcat(fileName,reqstr);
                response_File(fileName,"text/css");
               } else 
            if  (strcmp(reqstr,"js")==0){ //GET  js
                  geturistr(reqstr,uristr,2);
                strcpy(fileName,"/sd/js/");
                strcat(fileName,reqstr);
               res=  response_File(fileName,"text/javascript");
               } else
        //  if  (strcmp(reqstr,"views")==0){ //GET  js
               { 
                // geturistr(reqstr,uristr,2);
                strcpy(fileName,"/sd/views/");
                strcat(fileName,reqstr);
              //   strcat(fileName,".html");
                 printf("fileName=%s\n",fileName);
               res=  response_File(fileName,"text/html");
             
                }
              if (!res)
              {
                   sprintf(httpHeader,"HTTP/1.1 404 Not Found\r\nContent-Type: text/html\r\n");
                    client.send(httpHeader,strlen(httpHeader));           
                      client.send("Page not found!\n",16);
                  }  
            }   else
              if (strncmp(buffer, "PUT ", 4)==0){
                uristr = buffer + 4;
                eou = strstr(uristr, " ");
                *eou = 0;
                geturistr(reqstr,uristr,1);
                 printf("PUT%s+\n",uristr);
               if (strcmp(reqstr,"LEDControl")==0){ 
                 geturistr(reqstr,uristr,2);
                 printf("%s\n",reqstr);
                 params= reqstr ;
                 int n=getparamName(temp, params);
                 printf("name=%s\n",temp);
                 params=params+n;
                   n=getparamValue(temp,params);
                 printf("val=%s\n",temp);
                     if (strcmp(temp,"1")==0)
                    { myled=1;}
                     else {myled=0;}
                       sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n");
                       client.send(httpHeader,strlen(httpHeader));           
                      client.send("OK\n",3);
                 }
               }else {
               sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));           
            client.send("BAD The World!\n",15);
             }      
    //     }             
      client.close();   
    }
}
