#include "mbed.h"
#include "EthernetInterface.h"
#include "http_request.h"
#include "http_response.h"
#include "MbedJSONValue.h"
 #include <string>
static const char*          mbedIp       = "192.168.31.28";  //IP
static const char*          mbedMask     = "255.255.255.0";  // Mask
static const char*          mbedGateway  = "192.168.31.1";    //Gateway
DigitalOut myled(PF_14);
EthernetInterface eth;
TCPSocket socket;
char uri[256];
char devid[] = "34485081"; 
char api_key[] ="m7ARDyXF2QmO5O7u7UaBO8HHPpU=";
char host[] = "api.heclouds.com";
int softTime;
int main() {
    float temp;
    char body[64];
     MbedJSONValue demo;
     HttpRequest*request;
     HttpResponse* response;
    printf("modular-2 Connect to OneNet\n");
    eth.set_network(mbedIp,mbedMask,mbedGateway);
    eth.connect();  
    socket.open(&eth);
    socket.connect("api.heclouds.com", 80);
    softTime=0;
    while(1) {
        wait(1.0); // 1 sec
        softTime++;
        if (softTime>4)
        { 
        softTime=0;
        temp=(((double) rand() / (RAND_MAX)) + 1)*100;
         sprintf(body,"{\"temperature\":%f}",temp);
        uri[0] = 0;
        strcat(uri,"http://api.heclouds.com/devices/");
        strcat(uri,devid);
        strcat(uri,"/datapoints?type=3");
       request=new HttpRequest(&eth,HTTP_POST,uri);
       request->set_header("api-key",api_key);
       request->set_header("Content-Type", "application/json"); 
       sprintf(body,"{\"temperature\":%f}",temp); 
        response= request->send(body, strlen(body));
       printf("status is %d - %s\n", response->get_status_code(), response->get_status_message().c_str());
  //  printf("body is:\n%s\n", response->get_body_as_string().c_str());
      delete request;
      }
      // get switch
       uri[0] = 0;
        strcat(uri,"http://api.heclouds.com/devices/");
        strcat(uri,devid);
        strcat(uri,"/datastreams/switch");
      //   strcat(http_cmd,"switch");
      request=new HttpRequest(&eth,HTTP_GET,uri);
       request->set_header("api-key",api_key);
       request->set_header("Content-Type", "application/json"); 
     
       response= request->send(body, strlen(body));
  //  printf("body is:\n%s\n", response->get_body_as_string().c_str());  
     parse(demo, response->get_body_as_string().c_str()); 
    int sw;
    sw=demo["data"]["current_value"].get<int>();
    printf("sw=%d\n",sw);
    myled=sw;
        delete request;
    }
}
