/*
  modbus  comuunication class
   By modular-2 team 2018/8/3
  modbus  mode=RTU master/salve
  usage:
  master mode:
     sendQuery
     waitResponse
  salve mode:
        waitQuery
        sendResponse
   */
#ifndef MODBUS_H
#define MODBUS_H
#include "mbed.h"
class Modbus
{
    public:
      Modbus(PinName tx, PinName rx,PinName txEnable, int baud);
      bool sendQuery(uint8_t address,uint8_t function,uint16_t startAddress,uint16_t points);
      int  waitResponse(uint8_t *data);
      bool  waitQuery(uint8_t &address,uint8_t &function,uint16_t &startAddress,uint16_t &points);
      bool sendResponse(uint8_t *data,uint8_t length); 
    private:
        uint8_t sbuf[32];
        uint8_t rbuf[32];
        Serial rs485;
        DigitalOut dir;
        uint8_t _address;
        uint8_t _function;
        uint16_t _startAddress;
        uint16_t _points;
        unsigned int  calculateCRC16( uint8_t *puchMsg,unsigned int  usDataLen);
    };
#endif    