/*
 * DTU for QianBang Robot Project
 * Interface use Modular2_DIO10_V1.0
 * Communication use Modular2_RS485_V1.0
 * Copyright (c) 2019, Maximlab. All rights reserved.
 */
#include "mbed.h"
#include "modbus.h"
DigitalIn DI0(PF_5);
DigitalIn DI1(PF_3);
DigitalIn DI2(PF_7);
DigitalIn DI3(PF_6);
DigitalIn DI4(PA_5);
DigitalIn DI5(PB_8);
DigitalIn DI6(PF_10);
DigitalIn DI7(PF_4);
DigitalIn DI8(PF_8);
DigitalIn DI9(PF_9);
DigitalOut DO0(PE_11);
DigitalOut DO1(PE_7);
DigitalOut DO2(PB_0);
DigitalOut DO3(PA_4);
DigitalOut DO4(PC_2);
DigitalOut DO5(PF_2);
DigitalOut DO6(PF_0);
DigitalOut DO7(PF_1);
DigitalOut DO8(PC_0);
DigitalOut DO9(PC_3);
DigitalOut HF(PD_14);
DigitalOut led1(PC_6);
Modbus slave(PB_6,PB_7,PD_12,9600);
uint8_t myAddress=0x06;//Slave address
uint16_t data[32];
uint16_t readDI(uint16_t address)
{ 
   uint16_t terminal=address-100;
   switch(terminal)
   {
       case 0:{
           if (DI0) return 0xffff;
           else return 0;
           } 
     case 1:{
          if (DI1) return 0xffff;
           else return 0;
          } 
     case 2:{
        if (DI2) return 0xffff;
           else return 0;
            } 
     case 3:{
         if (DI3) return 0xffff;
           else return 0;
            } 
     case 4:{
            if (DI4) return 0xffff;
           else return 0;
             } 
     case 5:{
             if (DI5) return 0xffff;
           else return 0;
             } 
     case 6:{
             if (DI6) return 0xffff;
           else return 0;
            } 
     case 7:{
            if (DI7) return 0xffff;
           else return 0;
            } 
     case 8:{
           if (DI8) return 0xffff;
           else return 0;
           } 
     case 9:{
            if (DI9) return 0xffff;
           else return 0;
            } 
     } 
   return 0;  
 }
 uint16_t writeDO(uint16_t address,uint16_t value)
{ 
   uint16_t terminal=address-120;
   switch(terminal)
   {
       case 0:{
           DO0=value&0x0001;
           if (DO0) return 0xffff;
           else return 0;
           } 
     case 1:{
          DO1=value&0x0001;
          if (DO1) return 0xffff;
           else return 0;
          } 
     case 2:{
        DO2=value&0x0001;
        if (DO2) return 0xffff;
           else return 0;
            } 
     case 3:{
         DO3=value&0x0001;
         if (DO3) return 0xffff;
           else return 0;
            } 
     case 4:{
          DO4=value&0x0001;
          if (DO4) return 0xffff;
           else return 0;
             } 
     case 5:{
            DO5=value&0x0001;
            if (DO5) return 0xffff;
           else return 0;
             } 
     case 6:{
          DO6=value&0x0001;
          if (DO6) return 0xffff;
           else return 0;
            } 
     case 7:{
           DO7=value&0x0001;
           if (DO7) return 0xffff;
           else return 0;
            } 
     case 8:{
          DO8=value&0x0001;
          if (DO8) return 0xffff;
           else return 0;
           } 
     case 9:{
           DO9=value&0x0001;
           if (DO9) return 0xffff;
           else return 0;
            } 
     } 
  return 0; 
 }
void waitQuery()
{   uint8_t address;
    uint8_t function;
    uint16_t startAddress;
    uint16_t points;
    int i;
   if(slave.waitQuery(address,function,startAddress,points))
     {  printf("address=%d function:%d startAddress:%d Points:%d\n",address,function,startAddress,points);
        if ((address==myAddress)&&(function==0x03))  
        { //read reigster
         
          uint16_t p=startAddress;
          for (i=0;i<points;i++)
          {
            data[i]= readDI(p++);
            }
          slave.sendResponse((uint8_t *)data,(uint8_t)(points*2));
         } else
         if ((address==myAddress)&&(function==0x06))
         { //write register
     
            data[0]= writeDO(startAddress,points);     
            slave.sendResponse((uint8_t *)data,2);
             }
      }
    }
int main() {
    int i;
    printf("modbus controller\n");
    HF=1;
    while (true) {
        waitQuery();
        led1 = !led1;
      
              
    }
}

