#include "mbed.h"
#include "EthernetInterface.h"
#include "http_request.h"
#include "http_response.h"
DigitalOut myled(PF_12);
DigitalOut red(PF_14);
DigitalOut dir(PG_15);
RawSerial rs485(PE_1,PE_0,9600);
#define GET_ADDRESS 0x13
#define GET_DATA   0x11
#define SERVER_PORT   8000
#define SERVER_ADDR "192.168.1.10"
static const char*          mbedIp       = "192.168.1.120";  //IP
static const char*          mbedMask     = "255.255.255.0";  // Mask
static const char*          mbedGateway  = "192.168.1.10";    //Gateway
Thread recv;
EthernetInterface eth;   
      
void polling(char *address,uint8_t code,char *sbuf,int slen)
{
 char buf[32];
 int len,i,k;
 uint8_t checksum;
 checksum=0;
 i=0;
 buf[i++]=0xfe;
 buf[i++]=0xfe;
 buf[i++]=0xfe;
 buf[i++]=0xfe;
 buf[i++]=0x68;checksum=0x68;
 for (k=0;k<6;k++)
{ buf[i++]=address[k];
checksum=checksum+address[k];
};
buf[i++]=0x68;checksum=checksum+0x68;
 buf[i++]=code;checksum=checksum+code;
  buf[i++]=slen;checksum=checksum+slen;
  for (k=0;k<slen;k++)
    {
  buf[i++]=sbuf[k];checksum=checksum+sbuf[k];
  }
  buf[i++]=checksum;
  buf[i++]=0x16;
    buf[i++]=0xfe;
      buf[i++]=0xfe;
   len=i;
  dir=1;
  for (i=0;i<len;i++)
   rs485.putc(buf[i]);
  //  wait(0.03);
   dir=0;
 }
void CmdParser(uint8_t code,char *rbuf,int len)
{ int i;
char value[32];
double v;
 switch(code)
 {
     case 0x93:{
         printf("meter Address=");
           for(i=0;i<6;i++)
                printf("%02x",rbuf[5-i]-0x33);
                printf("\n");
         break;
     }
     case 0x91:{
      //   printf("meter readout");
         for(i=0;i<4;i++)
               { //printf("%02x",rbuf[7-i]-0x33);
                 value[i]=rbuf[7-i]-0x33;
                 }
         //printf("\n");
         v=((value[0]&0xf0)>>4)*100000;
         v=v+(value[0]&0x0f)*10000; 
         v=v+((value[1]&0xf0)>>4)*1000;
         v=v+(value[1]&0x0f)*100; 
         v=v+((value[2]&0xf0)>>4)*10;
         v=v+(value[2]&0x0f); 
         v=v+((double)((value[3]&0xf0)>>4)/10);
         v=v+((double)(value[3]&0x0f)/100); 
         sprintf(value,"%.2f",v);
      //   printf(value,"%.2f\n",v);
         // uplaod to web server
        char body[32] ;//= "{\"value\":\"world\"}";
        strcpy(body,"{\"value\":\"");
        strcat(body,value);
        strcat(body,"\"}");
         HttpRequest* request = new HttpRequest(&eth, HTTP_POST, "http://192.168.1.10:8000/readOut");
          request->set_header("Content-Type", "application/json"); 
          HttpResponse* response= request->send(body, strlen(body));          
          delete request ;       
                break;
         }
     }
 }
 void receive()
 { uint8_t state,ch;
   int i;
   char rbuf[32];
   char address[6];
   uint8_t code,len;
   state=0;
   while(true)
   {
   switch(state)
   {
     case 0:{
             ch=rs485.getc();
             if (ch==0xfe) state=1; 
             break;
             };
     case 1:{
               ch=rs485.getc();
             if (ch==0x68) {state=2;i=0;}
             else if (ch!=0xfe) state=0;
            
            break;
            }
     case 2:{ // read address
              ch=rs485.getc() ;
              address[i++]=ch;
              if (i==6) state=3;
              break;
            } 
     case 3:{
            ch=rs485.getc() ;
            if (ch==0x68) state=4;else state=0;
            break;
            }       
     case 4:{ //code
             ch=rs485.getc() ;
             code =ch;
             state=5;
             break;
             } 
    case 5:{
           ch=rs485.getc() ;
           i=0;len=ch;
           state=6; 
           break;
           }
    case 6:{
           ch=rs485.getc() ;
           rbuf[i++]=ch;
           if (i==len) state=7;
           break;
           } 
           case 7:{
                 ch=rs485.getc() ;
                 state=8;
                 break;
               }                                   
     case 8:{ 
              ch=rs485.getc() ;
              if (ch==0x16) {
                CmdParser(code,rbuf,len);
                
                  
                  }
              else
                printf("err\n");
                state=0;
              break;  
              }    
     }
     }
} 
int main() {

char address[6];
char sbuf[16];
bool flg;
/*address[0]=0xaa;
address[1]=0xaa;
address[2]=0xaa;
address[3]=0xaa;
address[4]=0xaa;
address[5]=0xaa;*/
 eth.set_network(mbedIp,mbedMask,mbedGateway);
eth.connect();
printf("\nMy device IP Address is %s\n", eth.get_ip_address()); 
printf("\nServer MAC Address is %s\n", eth.get_mac_address());
flg=true;
dir=0;
//rs485.set_format(8,UARTSerial::None,1);
printf("read electricity meter demo\n");
recv.start(&receive); 
address[0]=0x00;
address[1]=0x40;
address[2]=0x08;
address[3]=0x13;
address[4]=0x00;
address[5]=0x65;
sbuf[0]=0x33;
sbuf[1]=0x33;
sbuf[2]=0x34;
sbuf[3]=0x33;
    while(1) {
        wait(2);
        polling(address,GET_DATA,sbuf,4);
     //  receive();
      if (flg){flg=false;myled=1;}
       else {flg=true;myled=0;}
    }
}
