#include "mbed.h"
#include "stm32f4xx_hal.h"
//#include "stm32f4xx_hal_dma.h"
DigitalOut myled(PF_14);
DAC_HandleTypeDef hdac;
DMA_HandleTypeDef hdma_dac;
const double pi = 3.141592653589793238462;
const double amplitude = 0.5f;
const double offset = 65535/2;
const int waveformLength=120;
const int sineWave[waveformLength] {
    0x7ff, 0x86a, 0x8d5, 0x93f, 0x9a9, 0xa11, 0xa78, 0xadd, 0xb40, 0xba1,
    0xbff, 0xc5a, 0xcb2, 0xd08, 0xd59, 0xda7, 0xdf1, 0xe36, 0xe77, 0xeb4,
    0xeec, 0xf1f, 0xf4d, 0xf77, 0xf9a, 0xfb9, 0xfd2, 0xfe5, 0xff3, 0xffc,
    0xfff, 0xffc, 0xff3, 0xfe5, 0xfd2, 0xfb9, 0xf9a, 0xf77, 0xf4d, 0xf1f,
    0xeec, 0xeb4, 0xe77, 0xe36, 0xdf1, 0xda7, 0xd59, 0xd08, 0xcb2, 0xc5a,
    0xbff, 0xba1, 0xb40, 0xadd, 0xa78, 0xa11, 0x9a9, 0x93f, 0x8d5, 0x86a,
    0x7ff, 0x794, 0x729, 0x6bf, 0x655, 0x5ed, 0x586, 0x521, 0x4be, 0x45d,
    0x3ff, 0x3a4, 0x34c, 0x2f6, 0x2a5, 0x257, 0x20d, 0x1c8, 0x187, 0x14a,
    0x112, 0x0df, 0x0b1, 0x087, 0x064, 0x045, 0x02c, 0x019, 0x00b, 0x002,
    0x000, 0x002, 0x00b, 0x019, 0x02c, 0x045, 0x064, 0x087, 0x0b1, 0x0df,
    0x112, 0x14a, 0x187, 0x1c8, 0x20d, 0x257, 0x2a5, 0x2f6, 0x34c, 0x3a4,
    0x3ff, 0x45d, 0x4be, 0x521, 0x586, 0x5ed, 0x655, 0x6bf, 0x729, 0x794
};

/* DAC init function */
 TIM_HandleTypeDef htim2;
static void TIM2_Init(void)
{
    TIM_MasterConfigTypeDef sMasterConfig;
    TIM_ClockConfigTypeDef sClockSourceConfig;
    
     __TIM2_CLK_ENABLE();
    htim2.Instance = TIM2;
    htim2.Init.Prescaler =0;// 88K sineWave HAL_RCC_GetSysClockFreq() / (sampleRate * 2) - 1;
    htim2.Init.CounterMode = TIM_COUNTERMODE_UP;
    htim2.Init.Period = 1;
    htim2.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1;
    htim2.Init.RepetitionCounter = 0;
    HAL_TIM_Base_Init(&htim2);
 sClockSourceConfig.ClockSource = TIM_CLOCKSOURCE_INTERNAL;
  if (HAL_TIM_ConfigClockSource(&htim2, &sClockSourceConfig) != HAL_OK)
  {
   // _Error_Handler(__FILE__, __LINE__);
  }
    sMasterConfig.MasterOutputTrigger = TIM_TRGO_UPDATE;
    sMasterConfig.MasterSlaveMode = TIM_MASTERSLAVEMODE_DISABLE;
    HAL_TIMEx_MasterConfigSynchronization(&htim2, &sMasterConfig);
   HAL_TIM_Base_Init(&htim2);
    HAL_TIM_Base_Start(&htim2);
   // HAL_TIM_Base_Start_IT(&htim2);
   //  HAL_NVIC_SetPriority(TIM2_IRQn, 0, 0);
   //  HAL_NVIC_EnableIRQ(TIM2_IRQn);
    }
static void MX_DAC_Init(void)
{

  DAC_ChannelConfTypeDef sConfig;

    /**DAC Initialization 
    */
  hdac.Instance = DAC;
  if (HAL_DAC_Init(&hdac) != HAL_OK)
  {
     //_Error_Handler(__FILE__, __LINE__);
  }

    /**DAC channel OUT1 config 
    */
   sConfig.DAC_Trigger = DAC_TRIGGER_T2_TRGO;
   sConfig.DAC_OutputBuffer = DAC_OUTPUTBUFFER_ENABLE;
   if (HAL_DAC_ConfigChannel(&hdac, &sConfig, DAC_CHANNEL_1) != HAL_OK)
    {
    //_Error_Handler(__FILE__, __LINE__);
   }
 }

void HAL_DAC_MspInit(DAC_HandleTypeDef* hdac)
{

  GPIO_InitTypeDef GPIO_InitStruct;
  if(hdac->Instance==DAC)
  {
  /* USER CODE BEGIN DAC_MspInit 0 */
__HAL_RCC_GPIOA_CLK_ENABLE();
  /* USER CODE END DAC_MspInit 0 */
    /* Peripheral clock enable */
    __HAL_RCC_DAC_CLK_ENABLE();
    /**DAC GPIO Configuration    
    PA4     ------> DAC_OUT1 
    */
    GPIO_InitStruct.Pin = GPIO_PIN_4;
    GPIO_InitStruct.Mode = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull = GPIO_NOPULL;
    HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);
  
  }
}
void HAL_DAC_MspDeInit(ADC_HandleTypeDef* hdac)
{
    HAL_DMA_DeInit(hdac->DMA_Handle);
     }
static void MX_DMA_Init(void) 
{
  /* DMA controller clock enable */
  __HAL_RCC_DMA1_CLK_ENABLE();  
   hdma_dac.Instance =DMA1_Stream5;
   hdma_dac.Init.Channel = DMA_CHANNEL_7;
   hdma_dac.Init.Direction = DMA_MEMORY_TO_PERIPH;
   hdma_dac.Init.PeriphInc = DMA_PINC_DISABLE;
   hdma_dac.Init.MemInc = DMA_MINC_ENABLE;
   hdma_dac.Init.PeriphDataAlignment = DMA_PDATAALIGN_WORD;
   hdma_dac.Init.MemDataAlignment = DMA_PDATAALIGN_WORD;
   hdma_dac.Init.Mode = DMA_CIRCULAR;
   hdma_dac.Init.Priority = DMA_PRIORITY_VERY_HIGH;
   hdma_dac.Init.FIFOMode = DMA_FIFOMODE_DISABLE;
  
   HAL_DMA_Init(&hdma_dac);
   __HAL_LINKDMA(&hdac,DMA_Handle1,hdma_dac);
  /* DMA interrupt init */
  /* DMA1_Channel1_IRQn interrupt configuration */
  HAL_NVIC_SetPriority(DMA1_Stream5_IRQn, 0, 0);
  HAL_NVIC_EnableIRQ(DMA1_Stream5_IRQn);

}
extern "C" void DMA1_Stream5_IRQHandler(void)
{
    //HAL_DMA_IRQHandler(&hdma_dac);
     //myled=!myled;
   HAL_DMA_IRQHandler(&hdma_dac);
}

void HAL_DAC_ConvCpltCallbackCh1(DMA_HandleTypeDef *hdma)
{
    
  HAL_DAC_Start_DMA(&hdac, DAC_CHANNEL_1, (uint32_t*)sineWave, waveformLength, DAC_ALIGN_12B_R);
   myled=!myled;
 
} 
extern "C" void TIM2_IRQHandler()
{
    HAL_TIM_IRQHandler(&htim2);
}
    double rads = 0.0;
  uint16_t sample = 0;
  int i=0;
void HAL_TIM_PeriodElapsedCallback(TIM_HandleTypeDef *htim)
{
  // for (int i = 0; i < 360; i++) {
  /*        rads = (pi * i) / 180.0f;
          i++;if(i==360) i=0;
         sample = (uint16_t)(amplitude * (offset * (cos(rads + pi))) + offset);
      HAL_DAC_SetValue(&hdac, DAC_CHANNEL_1, DAC_ALIGN_12B_L, sample);
      HAL_DAC_Start(&hdac,DAC_CHANNEL_1);
   myled=!myled;*/
}    
int main() {
   
MX_DAC_Init();
//HAL_DAC_MspInit(&hdac);
 MX_DMA_Init() ;
TIM2_Init();
//HAL_DAC_Start(&hdac,DAC_CHANNEL_1);
 HAL_DAC_Start_DMA(&hdac, DAC_CHANNEL_1, (uint32_t*)sineWave, waveformLength, DAC_ALIGN_12B_R);
printf("DAC DMA demo\n");
myled=1;
 //HAL_TIM_Base_Start(&htim2);
    while(1) {
    //  wait(0.1);
      //myled=!myled;
     
      wait_us(100);
        // }
    }
}
