#include "mbed.h"
#include "C12832_lcd.h"

//program   description
//author:  TAO YAN
//date:June 5 2014
//this program is used to analog  4 roads usage
//there are 4 roads: road1,  road2,  road3 and vip_road
// each time only one road is opened for transportation
//road1,road 2,and road3 are polled scheduled periodically: road1->road2->road3->road1->road2->road3
//however, if programm detected vip road's request open signal:by push center button
// program will act as an preemptive OS, hang current road, and schedule vip road
// when vip road's transportation finished, system will resume the previous road that was interrupted by the vip road: such as below
// road1 run--->system detects vip road signal->vip road run->road1 run->road2 run->road3 run->road1 run->
//road2 run->ystem detects vip road signal->vip road run->road2 run->road3 run->road1 run

// LCD and Joystick Setting
C12832_LCD lcd;

BusIn Up(p15);
BusIn Down(p12);
BusIn Left(p13);
BusIn Right(p16);
BusIn Center(p14);


 
BusOut leds(LED1,LED2,LED3,LED4);

// Custom Function 
void initialize();



typedef enum
{
        Road1_can_Pass=0,
        Road2_can_Pass,
        Road3_can_Pass,
        vip_Road4_mustPass_now,

}STATE;

#define switch_to_vip_road 1
#define road1 1
#define road2 2
#define road3 3

int main()
{
    int index=0,is_now_swith_vip_road=0,return_from_vip_road=0;        
    int current_state = Road1_can_Pass;
    initialize(); 
     while(1)
        {
                lcd.locate(0,15); 
                switch(current_state)
                {

                                case Road1_can_Pass:  
                                is_now_swith_vip_road=0;
                                return_from_vip_road=0;
                                 leds=1;                    
                                 initialize();
                                 lcd.printf("now road1 open\n");
                                 for(index=0;index<660000;index++)                 
                                 {
                                         if(Center)
                                         {
                                             leds=0;      
                                             is_now_swith_vip_road=switch_to_vip_road;
                                             return_from_vip_road=road1;
                                               break;
                                         }                                      
                                         leds!=leds;
                                 }
                                 if(is_now_swith_vip_road==switch_to_vip_road)  //if button center entered, means intrruptedbyviproad,return to road1 when vip road transoirtation finished
                                {
                                     current_state=vip_Road4_mustPass_now;
                                         initialize(); 
                                      lcd.printf("confirm vip road request open signal, switch to vip road transportation\n");
                                      wait(1);
                                          initialize(); 
                                       lcd.printf("when vip road transportation finished, switched return to road1\n");
                                       wait(1);
                                 }
                                 else
                                 {
                                    current_state = Road2_can_Pass;  
                                        initialize();   
                                   lcd.printf("road1 tranportation will finished,now will switch to road 2\n");//sequence:road1, road2 ,road3 periodically
                                      wait(1);                                                            
                                  }
                                  break;
                                     
                                     
                                     
                                     
                               case Road2_can_Pass:
                               is_now_swith_vip_road=0;
                               return_from_vip_road=0;
                                        leds=2;
                                  initialize();
                                 lcd.printf("now road2 open\n");
                                  for(index=0;index<660000;index++)
                                   {
                                      if(Center)
                                         {
                                             leds=0;      
                                             is_now_swith_vip_road=switch_to_vip_road;
                                             return_from_vip_road=road2;
                                               break;
                                         }                                      
                                         leds!=leds;
                                   }
                                   if(is_now_swith_vip_road==switch_to_vip_road)
                                   {
                                       current_state=vip_Road4_mustPass_now;
                                       initialize(); 
                                      lcd.printf("confirm vip road request open signal, switch to vip road transportation\n");
                                      wait(1);
                                          initialize(); 
                                       lcd.printf("when vip road transportation finished, switched return to road2\n");
                                       wait(1);
                                   }
                                   else
                                   {
                                       current_state = Road3_can_Pass; 
                                       initialize();   
                                       lcd.printf("road2 tranportation will finished,now will switch to road 3 transportation\n");//sequence:road1, road2 ,road3 periodically
                                       wait(1);                                 
                                   }
                                   break;
                              
                              
                             case Road3_can_Pass:
                             is_now_swith_vip_road=0;
                             return_from_vip_road=0;
                                  leds=4;
                                 initialize();
                                 lcd.printf("now road3 open\n");
                                  for(index=0;index<660000;index++)
                                  {
                                         if(Center)
                                         {
                                             leds=0;      
                                             is_now_swith_vip_road=switch_to_vip_road;
                                             return_from_vip_road=road3;
                                               break;
                                         }                                      
                                         leds!=leds;
                                 }
                                 if(is_now_swith_vip_road==switch_to_vip_road)
                                 {
                                       current_state=vip_Road4_mustPass_now;
                                      initialize(); 
                                      lcd.printf("confirm vip road request open signal, switch to vip road transportation\n");
                                      wait(1);
                                          initialize(); 
                                       lcd.printf("when vip road transportation finished, switched return to road3\n");
                                       wait(1);
                                 }
                                 else
                                 {
                                     current_state = Road1_can_Pass;   
                                        initialize();   
                                       lcd.printf("road3 tranportation will finished,now will periodically switch to road 1 transportation\n");//sequence:road1, road2 ,road3 periodically
                                       wait(1);                                 
                                  }
                                  break;
                           case vip_Road4_mustPass_now:
                                        leds=8;
                                        initialize();
                                        lcd.printf("now vip road open\n");
                                        for(index=0;index<660000;index++)
                                        {
                                               leds!=leds;                                       
                                        }
                                        if(return_from_vip_road==road1)
                                        {
                                            current_state = Road1_can_Pass; 
                                            initialize(); 
                                            lcd.printf("now vip road transportation finished, switched return to road1\n");
                                            wait(1);        
                                        }
                                        else if(return_from_vip_road==road2)
                                        {
                                            current_state = Road2_can_Pass;   
                                            initialize(); 
                                            lcd.printf("now vip road transportation finished, switched return to road2\n");
                                            wait(1);         
                                        }
                                        else if(return_from_vip_road==road3)
                                        {
                                            current_state = Road3_can_Pass;         
                                            initialize(); 
                                            lcd.printf("now vip road transportation finished, switched return to road3\n");
                                            wait(1);   
                                        }                                                                                
                                        break;
                        
                                default:
                                        break;
                        }
        }
        return 0;
}
void initialize()
{
    lcd.cls();
    lcd.locate(0,0);   
}
