#include "mbed.h"
#include "commande.h"
#include <SRF08.h>
#define adr 128

//***************************************************
//************** Déclaration des objets *************
//***************************************************

Serial bt(p13, p14);
PwmOut pwm(p26); //objet
Serial pc(USBTX,USBRX);
SRF08 capt(p28,p27,0xE0);
AnalogIn optique(p15);

commande robot;

//***************************************************
//************** Prototypes fonctions ***************
//***************************************************

void PWM(void); // prototype fonction (cfr bas)
void acqui(void);
void autonomie(void);


//***************************************************
//**************** Variables Gobales ****************
//***************************************************

float pulse;
int distance;
unsigned c;
float droite, gauche,devant,capteur;
int right,left,straight,vu;

//***************************************************
//********************** MAIN ***********************
//***************************************************

int main()
{
    bt.baud(57600);
    while(1)
    {
        autonomie();
        /*while(1){
        char choix = bt.getc();

                if(choix=='0'){
                    robot.avancer(50);bt.printf("avance\n");}
                else if(choix=='1'){
                    robot.reculer(50);bt.printf("recule\n");}
                else if(choix=='2'){
                    robot.tourner_gauche(60);bt.printf("gauche\n");} 
                else if(choix=='3'){
                    robot.tourner_droite(60);bt.printf("droite\n");} 
                else if(choix=='4'){
                    robot.stop();bt.printf("stop\n\r");}
                else if(choix=='5')
                    break;
        }*/
    }
}

//****************************************************
//******************** Fonctions *********************
//****************************************************


/*void direction ( int x) //objectif faire le CHOIX de la meilleure direction
{
    if((straight < (left + 10)) && (straight < (right + 10))
        {robot.avancer(50);bt.printf("avance\n");}
    if((left > (right + 15)) && (left >= (straight + 15))){ // pourquoi le + XX ? parce que le capteur est trop sensible pour varier suivant l'unité choisie
        robot.tourner_droite(60);bt.printf("droite\n"); // comparaison capteur relevé devant, à gauche et à droite, => la valeur la plus faible (= obstacle le + loin) l'emporte
        robot.avancer(50);bt.printf("avance\n");}
    if((right > (left + 15)) && (right >= (straight + 15))){
        robot.tourner_gauche(60);bt.printf("gauche\n");
        robot.avancer(50);bt.printf("avance\n");}
}*/
void autonomie()
{
    pwm.period_ms(20);  //définition da la largeur de l'impulsion: 20 ms
    pulse=0.0715;
    
    while(1)
    {
            
        pulse=0.0715;pwm.write(pulse);acqui(); //capteur centre
        devant=vu; straight=capteur;
        if(straight>50)
            robot.avance(50);
        while(devant<60  && straight<50)
            {
                robot.stop();
                pulse=0.095;wait(0.03);pwm.write(pulse);acqui(); //capteur gauche
                gauche=vu; left=capteur;
                  
                pulse=0.048;wait(0.03);pwm.write(pulse);acqui(); //dcapteur roite
                droite=vu; right=capteur;
                
                if(gauche<droite)
                    {
                        robot.tourner_gauche(40);
                        wait(0.6);
                        robot.stop();
                    }
                else if(gauche>droite)
                    {
                        robot.tourner_droite(40);
                        wait(0.6);
                        robot.stop();
                    }
                pulse=0.0715;wait(0.03);pwm.write(pulse);acqui(); //capteur centre
                devant=vu; straight=capteur; 
            }
    }   
}
/*
        pulse=0.095;pwm.write(pulse);acqui(); //gauche
        gauche=vu; left=capteur;
        pulse=0.0715;pwm.write(pulse);acqui(); //centre
        devant=vu; straight=capteur;
        pulse=0.048;pwm.write(pulse);acqui(); //droite
        droite=vu; right=capteur;*/

void acqui()
{
        vu = optique.read_u16();
        vu = 422006/(vu-3475);
        capteur = capt.read();
        bt.printf("Sonar : %f.2\n",capt.read());
        bt.printf("Optique : %d\n",vu);
        wait(0.1);
}
