#include "mbed.h"
#include "commande.h"

#define adr 128
using namespace std;


DigitalOut S2(p11);
Serial com_mot(p9,p10);

void avancerG(char speed)
{
    com_mot.putc(adr);
    com_mot.putc(1);
    com_mot.putc(speed);
    com_mot.putc((adr + 1 + speed) & 127); //checksum trame envoyée / reçue 
}
void avancerD(char speed)
{
    com_mot.putc(adr);
    com_mot.putc(4);
    com_mot.putc(speed);
    com_mot.putc((adr + 4 + speed) & 127); //checksum trame envoyée / reçue 
}
void reculerG(char speed)
{
    com_mot.putc(adr);
    com_mot.putc(0);
    com_mot.putc(speed);
    com_mot.putc((adr + 0 + speed) & 127); //checksum trame envoyée / reçue 
}
void reculerD(char speed)
{
    com_mot.putc(adr);
    com_mot.putc(5);
    com_mot.putc(speed);
    com_mot.putc((adr + 5 + speed) & 127); //checksum trame envoyée / reçue 
}
//////////////Fonction Finale///////////////

///////Marche avant////////
void dem(char speed)
{
    int i;speed=speed*0.1;
    for(i=0;i<100;i++)
    {
    avancerG(speed);wait(0.001);
    avancerD(speed);speed++;
    wait(0.01);
    }
    avancerG(speed);wait(0.001);
    avancerD(speed);
}
void commande::avance(char speed)
{
    avancerG(speed);wait(0.001);
    avancerD(speed);
}

//////Fonction avancer//////
void commande::avancer(char speed)
{
    dem(speed);avance(speed);
}
//////////Marche arriere//////////
void demar(char speed)
{
    int i;
    speed=speed*0.1;
    for(i=0;i<100;i++)
    {
    reculerG(speed);wait(0.001);
    reculerD(speed);speed=speed++;
    wait(0.01);
    }
}
void commande::recu(char speed)
{
    reculerG(speed);wait(0.001);
    reculerD(speed);
}
//////Fonction reculer//////
void commande::reculer(char speed)
{
    demar(speed);recu(speed);
}
//////virage/////////////////
void commande::tourner_droite(char speed)
{
    avancerG(speed);wait(0.001);
    reculerD(speed);
}
void commande::tourner_gauche(char speed)
{
    avancerD(speed);wait(0.001);
    reculerG(speed);
}

void commande::demi_tour(void)
{
    avancerD(50);wait(0.001);
    reculerG(50);
    wait(1.3);
    avancerD(0);wait(0.001);
    reculerG(0);
}

void commande::stop(void)
{
    avancerD(0);wait(0.001);
    reculerG(0);
}
//////Fonction arret//////
//void arreter(void)
