/*
 * Balloons module Lampe
 * Autheur : Yann DOUZE douze.yann@gmail.com
 * Date : 2015/06/24
 * Version 0.9 
 */

#include "mbed.h"
#include "NeoStrip.h"
#include "nRF24L01P.h"
#define N 12
#define PATTERNS 4
#define TRANSFER_SIZE   4


Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(p5, p6, p7, p8, p9, p10);    // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

void pattern0();
void pattern1();
void pattern2();
void pattern3();
void heartbeat();
void circle_light();

unsigned char R=255;
unsigned char G=255;
unsigned char B=100;

/*
unsigned char R=249;
unsigned char G=66;
unsigned char B=58;
*/
//void pattern4();


// array of function pointers to the various patterns
void (*patterns[])(void) = {&pattern0, &pattern1, &pattern2, &pattern3};

NeoStrip strip(p20, N);
DigitalIn b1(p22); // brightness up
DigitalIn b2(p21); // brightness down
DigitalIn b3(p19); // bouton mamie

// timer used for debugging
Timer timer;
float bright = 0.95;	// 20% is plenty for indoor use
unsigned int sens=0;
float bri =0.01;

void circle_light()
{
	for (int i = 0; i < N; i++)
	{
		strip.setPixel(i, 0, 0, 0); //Black
	}	  
	strip.write();//eteint toute les leds
	for (int i = 0; i < N; i++) //allume les leds une à une
	{
		strip.setPixel(i, R, G, B); //Yellow
		strip.write();
		wait_ms(100);
	}	  
}

int main()
{
	b1.mode(PullDown);
	b2.mode(PullDown);
	b3.mode(PullDown);
	char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
	txData[0]='M'; //M comme Mami
	txData[1]='B'; //B comme Bouton
	txData[3]=0x31; //comme 1 en ASCII
    int txDataCnt = 4;
    int rxDataCnt = 0;
	int SendCounter=0;
	int pattern = 0;
	float bright = 0.5;	// 20% is plenty for indoor use
	bool b3o = b3;		// old copy of button 3 to poll for changes

	strip.setBrightness(bright);	// set default brightness
	
	 my_nrf24l01p.powerUp();

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    circle_light();

	while (true)
	{
		timer.reset(); // use a timer to measure loop execution time for debugging purposes
		timer.start(); // for this application, the main loop takes approximately 3ms to run

		// button 1 increases brightness
		if (b1 && bright < 1)
		{
			bright += 0.01;
			if (bright > 1)
				bright = 1;
			strip.setBrightness(bright);
		}

		// button 2 decreases brightness
		if (b2 && bright > 0)
		{
			bright -= 0.01;
			if (bright < 0)
				bright = 0;
			strip.setBrightness(bright);
		}
		
		if (b3 != b3o)
		{
			b3o = b3;
			myled1 = !myled1;
			if (b3)
			{
				pattern = 0;
            	pc.printf("Mamie a appuye sur le bouton ! \r\n");
            	txData[2]=SendCounter++;
            	if(SendCounter==255) SendCounter=0;
            	my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );      
            	circle_light();
            }
		}
		
		if ( my_nrf24l01p.readable() ) {

            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );

            // Display the receive buffer contents via the host serial link
            //for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {
			if(rxData[3]==12){
                pc.putc( rxData[0] );
                pc.putc( rxData[1] );
                pc.printf(" Message %d \r\n",rxData[2]);
                pattern=1;
                
            }
            if(rxData[3]==13){
                pc.putc( rxData[0] );
                pc.putc( rxData[1] );
                pc.printf(" Message %d \r\n",rxData[2]);
                pattern=2;
                
            }
            if(rxData[3]==14){
                pc.putc( rxData[0] );
                pc.putc( rxData[1] );
                pc.printf(" Message %d \r\n",rxData[2]);
                pattern=3;
                
            }
			
            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            myled2 = !myled2;
            sens=0;
            bri =0.01;
        }
		
		// run the pattern update function which sets the strip's pixels
		patterns[pattern]();
		strip.write();

		timer.stop();
		// print loop time if b3 is pressed
		if (b3)
			printf("Loop Time: %dus\n", timer.read_us());
		
		wait_ms(10);
	}
}

// pattern0 displays a static image
void pattern0()
{   
	for (int i = 0; i < N; i++)
	{
		strip.setPixel(i, R, G, B); //Yellow
	}
	strip.setBrightness(bright);
	
}

void heartbeat()
{
	if (bri>0.95f) sens =1;
	if (bri<0.25f) sens=0;
	
	if (sens==1)
	{
		bri -= 0.007;
	}

	if (sens==0)
	{
		bri += 0.007;
	}
	strip.setBrightness(bri);
}

void pattern1()
{
	for (int i = 0; i < N; i++)
	{
		strip.setPixel(i, 0, 191, 255); //DeepSkyBlue
	}
	heartbeat();
}

void pattern2()
{
	for (int i = 0; i < N; i++)
	{
		strip.setPixel(i, 255, 0, 255); //magenta
	}	
	heartbeat();
}

void pattern3()
{
	for (int i = 0; i < N; i++)
	{
		strip.setPixel(i, 255, 127, 0); //DarkOrange
	}	
	heartbeat();
}

