/*
 * Balloons module Ethernet
 * Autheur : Yann DOUZE douze.yann@gmail.com
 * Date : 2015/06/24
 * Version 0.9 
 */

#include "mbed.h"
#include "EthernetInterface.h"
#include "nRF24L01P.h"

/****** declaration des define ******/
#define SERIAL_DEBUG2
//#define SERIAL_DEBUG
//#define C_SENSOR_DEBUG
#define SEND_DEBUG
#define ON 0
#define OFF 1
#define TRANSFER_SIZE   4

/****** declaration des objets ******/

Serial pc(USBTX, USBRX);
nRF24L01P my_nrf24l01p(p5,  p6,   p7,   p8,     p9,   p10);    // mosi, miso, sck, csn, ce, irq
                    //P0_9, P0_8, P0_7, P0_6,   P0_0, P0_6  sur Arch Pro (LPC1768)
                    //D11,  D12,  D13,  D10,    D8,   D9    sur ARduino
                    
DigitalOut LEDG(LED1);
DigitalOut LEDR(LED2);
DigitalOut LEDB(LED3);
DigitalOut LEDW(LED4);
DigitalOut Led_green(P2_3);
DigitalOut Led_blue(P0_4);

/****** variables globales ******/

char APIServer[] = "mcuconnectorapi.azurewebsites.net";
int DeviceId=1200;
unsigned long MACId=0;
char MobileId1[]="\"12\"";
char MobileId2[]="\"13\"";
char MobileId3[]="\"14\"";
int checkMessageAvailableInterval = 2000;// ms
char messageIsAvailable[] = "/api/IsMessageAvailable/device/";
//String APIADDRESS_pushData = "api/PushData/type/";// << Il faut bien rajouter /value/{value} après le type!
char sayHello[]="/api/SayHello/device/";
char Get_message[]="GET %s%d HTTP/1.1\r\nHost: %s\r\nUser-Agent: arduino-ethernet\r\nConnection: close\r\n\r\n";
char Send_message[]="GET %s%d/recipient/%d HTTP/1.1\r\nHost: %s\r\nUser-Agent: arduino-ethernet\r\nConnection: close\r\n\r\n";
extern "C" void mbed_mac_address(char *mac); 


int main() {
    LEDB=1;
    LEDW=1;
    LEDR=0;
    LEDG=1;
    Led_green=0;
    Led_blue=0;
    EthernetInterface eth;
    int Last_MobileId=12;
    char mac[6];
    char http_cmd[256];
    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    txData[0]='A'; //A comme allume
    txData[1]='L'; //L comme lampe
    txData[3]=0x30;     
    int SendCounter=0;
    int txDataCnt = 4;
    int rxDataCnt = 0;
    pc.baud(115200);
    pc.printf("Hello World ! \r\n");
    pc.printf("Ethetnet Init ! \r\n");
    
    eth.init(); //Use DHCP
    int ret=eth.connect();
    if(ret==0)
    {
        pc.printf("IP Address is %s \r\n", eth.getIPAddress());
        LEDB=0;
        Led_blue=1;
        mbed_mac_address(mac);
        for(int i=0; i<6;i++) {
            printf("%02X ", mac[i]);
            MACId+=mac[i];
        }
        printf("\n");
        //MACId = atol(mac);
        printf("MacId= %d\n",MACId);
    }
    else
    {
        pc.printf("No Ethernet connection \r\n");
        LEDB=1;
        Led_blue=0;
    }
    
        
    TCPSocketConnection sock;
    my_nrf24l01p.powerUp();
     // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    //pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );
    
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    LEDW=0;
    while(1)
    {
        sock.connect(APIServer, 80);
        #ifdef SERIAL_DEBUG
        pc.printf("Fetch url ! \r\n");
        #endif
        sprintf(http_cmd,Get_message,messageIsAvailable,DeviceId,APIServer);
       
        //char http_cmd[] = "GET /api/IsMessageAvailable/device/1200 HTTP/1.1\r\nHost: mcuconnectorapi2.azurewebsites.net\r\nUser-Agent: arduino-ethernet\r\nConnection: close\r\n\r\n";                                       
        #ifdef SERIAL_DEBUG
        pc.printf("message : %d \r\n %s \r\n",strlen(http_cmd),http_cmd);
        #endif
        
        sock.send_all(http_cmd, sizeof(http_cmd)-1);
        
        char buffer[300];
        int ret;
        while (true) {
            ret = sock.receive(buffer, sizeof(buffer)-1);
            if (ret <= 0)
                break;
            buffer[ret] = '\0';
            #ifdef SERIAL_DEBUG
            pc.printf("Received %d chars from server:\r\n%s\r\n", ret, buffer);
            #endif
        }
        sock.close();

        if(strstr(buffer,MobileId1))
        {
            LEDG = 0;
            Led_green=1;
            pc.printf("Une pensee est arrive du mobile 12! \r\n");
            txData[2]=SendCounter++;
            txData[3]=12;
            if(SendCounter==255) SendCounter=0;
             my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );   
             Last_MobileId=12;      
        }
        if(strstr(buffer,MobileId2))
        {
            LEDG = 0;
            Led_green=1;
            pc.printf("Une pensee est arrive du mobile 13! \r\n");
            txData[2]=SendCounter++;
            txData[3]=13;
            if(SendCounter==255) SendCounter=0;
             my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );  
             Last_MobileId=13;       
        }
        if(strstr(buffer,MobileId3))
        {
            LEDG = 0;
            Led_green=1;
            pc.printf("Une pensee est arrive du mobile 14! \r\n");
            txData[2]=SendCounter++;
            txData[3]=14;
            if(SendCounter==255) SendCounter=0;
             my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
             Last_MobileId=14;      
        }
        
        if ( my_nrf24l01p.readable() ) {
            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
            if(rxData[3]==0x31){
                pc.putc( rxData[0] );
                pc.putc( rxData[1] );
                pc.printf(" Message %d \r\n",rxData[2]);
            }
            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            sock.connect(APIServer, 80);
            #ifdef SERIAL_DEBUG2
            pc.printf("Send SayHello !\r\n");
            #endif
            sprintf(http_cmd,Send_message,sayHello,DeviceId,Last_MobileId,APIServer);
           
            //char http_cmd[] = "GET /api/IsMessageAvailable/device/1200 HTTP/1.1\r\nHost: mcuconnectorapi2.azurewebsites.net\r\nUser-Agent: arduino-ethernet\r\nConnection: close\r\n\r\n";                                       
            #ifdef SERIAL_DEBUG2
            pc.printf("message : %d \r\n %s \r\n",strlen(http_cmd),http_cmd);
            #endif
            
            sock.send_all(http_cmd, sizeof(http_cmd)-1);
            while (true) {
                ret = sock.receive(buffer, sizeof(buffer)-1);
                if (ret <= 0)
                    break;
                buffer[ret] = '\0';
                #ifdef SERIAL_DEBUG2
                pc.printf("Received %d chars from server:\r\n%s\r\n", ret, buffer);
                #endif
            }
            sock.close();
            
            LEDG=1;
            Led_green=0;
        }
        
       
        wait_ms(checkMessageAvailableInterval);   
    }

}
