/* 
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name:Yang Zhenye
Username:el17zy
Student ID Number:201199680
Date:2020/5/12
*/

#include "RooneyEngine.h"

char buffer[14];
RooneyEngine::RooneyEngine(){}
RooneyEngine::~RooneyEngine(){}
void RooneyEngine::init() {
     reset();
     _start_flag = true;
     }
     
void RooneyEngine::reset() {
     _control.c.x=0;
     _player_x=38;
     _player_y=5;
     _collision_flag = false;
     _player_score = 0;
     _x = WIDTH/2 -  2/2;
     _y = HEIGHT/2 - 2/2;
     }

void RooneyEngine::read_input(Gamepad &gamepad) {
    _control.c = gamepad.get_mapped_coord();
//    X_flag = gamepad.check_event(Gamepad::X_PRESSED); 
}

void RooneyEngine::check_reset(N5110 &lcd, Gamepad &gamepad) {
 if(get_reset_flag()){
     gamepad.leds_on();
     lcd.clear();
     for (int i = 0; i<60; i++) {
         lcd.printString("lose the game", 0, 2);
         lcd.printString("sccore:", 0, 4);
         wait(0.001);
         sprintf(buffer,"%2d",_player_score); 
         lcd.printString(buffer,16,4);
         reset();
         }
         }
         }

void RooneyEngine::check_start(N5110 &lcd, Gamepad &gamepad) {
     if(_start_flag == true) { 
     check_reset(lcd, gamepad);} 
    _start_flag = get_start_flag(); 
    }
    
void RooneyEngine::check_collision(Gamepad &gamepad) { 
    if ((_player_x == _x - 2) && (_player_y == _y - 5)) {  
    _collision_flag = true;
    _player_score++;
    }
    }

int RooneyEngine::get_score() {
   return _player_score;}
    
void RooneyEngine::get_sprite(N5110 &lcd) {
    lcd.drawRect(_x,_y,10,20,FILL_BLACK);}

void RooneyEngine::update_lcd(N5110 &lcd) {
       get_sprite(lcd);
        sprintf(buffer,"%2d",_player_score);
       lcd.printString("score",0,0);
      lcd.printString(buffer,30,0); 
      }
      
int RooneyEngine::get_speed() {return _speed;}
    
void RooneyEngine::get_rooney_x(Gamepad &gamepad,int speed,float joy_x) {
   _speed=speed;
     if (joy_x < float(-0.5)){ 
         _speed=-0.5;
     _player_x=38+_speed;}
     else if (_x<=0){
         _speed = 0;
        }
    if (joy_x > float(0.5)){ 
     _speed=0.5;
    _player_x=38+_speed;}
    else if (_x>=80){
        _speed = 0;
        }
        }
bool RooneyEngine::get_reset_flag() {
        return _reset_flag;
        }

bool RooneyEngine::get_start_flag() {
        return _start_flag;
        }        
        
void RooneyEngine::run_engine(N5110 &lcd, Gamepad &gamepad) {
    init();
    reset();
    check_reset(lcd, gamepad);
    check_start(lcd, gamepad);
    check_collision(gamepad);
    _speed=get_speed();
    _player_score=get_score();
    get_sprite(lcd);
    _player.drawrooney(lcd);
    update_lcd(lcd);
    get_reset_flag();
    get_start_flag();
    get_rooney_x(gamepad,_speed,_control.c.x);
    }    
        

    
    
    
    
    