#ifndef ROONEY_H
#define ROONEY_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
enum rooneybody{left, right, stand};
class player
{
public:
 // Constructor and destructor.
  /**
  * @brief Constructor @details Non user specified.
  */
player();
  /**
  * @brief Destructor @details Non user specified.
  */
~player();
  /**
  * @brief Initialises the Rooney.
  */
void init();
  /**
  * @brief set the rooney position.
  */
void set_palyer_x(float joy_x, int speed);
  /**
  * @brief get the collision flag.
  * @param &gamepad @details The gamepad object from Gamepad class.
  */
bool collision_flag();
  /**
  * @brief set the rooney body form.
  */
int * get_form(rooneybody body);
  /**
  * @brief set the rooney body y.
  */
int get_y();
  /**
  * @brief set the rooney body x.
  */
int get_x();
  /**
  * @brief set the rooney speed
  */
int get_speed();
  /**
  * @brief add the score.
  */
void add_score();
  /**
  * @brief get the score.
  */
int get_score();
  /**
  * @draw form.
  */
int drawrooney(N5110 &lcd);

private:

int _player_x;
int _player_y;
bool _collision_flag;
int _speed;
int _x;
int _y;
int _score;
rooneybody body;
};
#endif
