/* 06_spi_max7219_led8x8
 *
 * Simple demo to drive a 8x8-as LED matrix by a MAX7219 LED driver IC
 * After initialisation two characters (H and W) are displayed alternatively.
 * The MAX7219 IC is driven by hardware SPI: SPI0 module at PTD1, PTD2, PTD3.
 */

#include "mbed.h"
#include "MMA8451Q.h"

PinName const SDA = PTE25;
PinName const SCL = PTE24;

SPI spi(PTD2, PTD3, PTD1);          // Arduino compatible MOSI, MISO, SCLK
DigitalOut cs(PTD0);                // Chip select
int  point []= {0,2};

#define MMA8451_I2C_ADDRESS (0x1d<<1)

const unsigned char led2[]= {
   0xFF,0xB4,0x15,0xD1,0x85,0xB5,0x95,0xFF};//maze wall

//0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};//no maze wall
unsigned char led1[]= {
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};  //

/// Send two bytes to SPI bus
void SPI_Write2(unsigned char MSB, unsigned char LSB)
{
    cs = 0;                         // Set CS Low
    spi.write(MSB);                 // Send two bytes
    spi.write(LSB);
    cs = 1;                         // Set CS High
}

bool isNotWall(int x,int y)
{
    bool result=false;
    if(x>=0&&x<8&&y>=0&&y<8) {
        int wallline =led2[y];
        int pointline=(unsigned char)(1<<(7-x));
        printf("%d %d\n",wallline,pointline);

        if((wallline|pointline)!=wallline) {
            result=true;

        }
        
        /*
        101
        100
        
       |101
       &100

        101
        010
        
       |111
       &000
       */
    }
    return result;
}
void direction(float x, float y)
{
    
    if(x > 0.5) {
        if(isNotWall(point[0]+1,point[1])) {
            point[0]++;
        }
        printf("Left %d %d\n",point[0],point[1]);
    } else if(x < -0.5) {
        if(isNotWall(point[0]-1,point[1])) {
            point[0]--;
        }
        printf("Right %d %d\n",point[0],point[1]);
    } else if(y > 0.5) {
        if(isNotWall(point[0],point[1]-1)) {
            point[1]--;
        }
        printf("Down %d %d\n",point[0],point[1]);
    } else if(y < -0.5) {
        if(isNotWall(point[0],point[1]+1)) {
            point[1]++;
        }
        printf("Up %d %d\n",point[0],point[1]);
    } else {
        printf("Neutral Position \n");
    }
}



/// MAX7219 initialisation
void Init_MAX7219(void)
{
    SPI_Write2(0x09, 0x00);         // Decoding off
    SPI_Write2(0x0A, 0x08);         // Brightness to intermediate
    SPI_Write2(0x0B, 0x07);         // Scan limit = 7
    SPI_Write2(0x0C, 0x01);         // Normal operation mode
    SPI_Write2(0x0F, 0x0F);         // Enable display test
    wait_ms(500);                   // 500 ms delay
    SPI_Write2(0x01, 0x00);         // Clear row 0.
    SPI_Write2(0x02, 0x00);         // Clear row 1.
    SPI_Write2(0x03, 0x00);         // Clear row 2.
    SPI_Write2(0x04, 0x00);         // Clear row 3.
    SPI_Write2(0x05, 0x00);         // Clear row 4.
    SPI_Write2(0x06, 0x00);         // Clear row 5.
    SPI_Write2(0x07, 0x00);         // Clear row 6.
    SPI_Write2(0x08, 0x00);         // Clear row 7.
    SPI_Write2(0x0F, 0x00);         // Disable display test
    wait_ms(500);                   // 500 ms delay
}


void clearMap(unsigned char *map )
{
    for (int i=0; i<8; i++) {
        map[i]=0x00;
    }
}

void updateMap( )
{
    clearMap(led1);
    led1[point[1]]=(unsigned char)(1<<(7-point[0]));

}


int main()
{

    cs = 1;                         // CS initially High
    spi.format(8,0);                // 8-bit format, mode 0,0
    spi.frequency(1000000);         // SCLK = 1 MHz
    Init_MAX7219();                 // Initialize the LED controller
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);



    while (1) {

        float x, y;
        x = acc.getAccX();
        y = acc.getAccY();

        direction(x,y);
        updateMap();


        wait(0.5);
        
        for(int i=1; i<9; i++)      // Write first character (8 rows)
            SPI_Write2(i,led1[i-1]|led2[i-1]);
        wait(0.5);
        for(int i=1; i<9; i++)      // Write first character (8 rows)
            SPI_Write2(i,led2[i-1]);
    }


}