#ifndef SmartLab_MuRata_UARTFrame
#define SmartLab_MuRata_UARTFrame

#include "Payload.h"
#include "CommandID.h"

namespace SmartLabMuRata
{
/*
 * 7 | 6 | 5 4 3 2 1 0
 *         SOM(0x02)
 * 1 |       L0
 * 1 | A |    L1
 * 1 |   Command ID
 *       Payload
 *       ...
 *       ...
 * 1 |   Checksum
 *         EOM(0x04)
 */

/*
 * Each frame is delineated by a Start of Message (SOM) and End of Message (EOM) byte. The rest of the
 * fields are as follows:
 * The frame starts with a SOM (0x02) and ends with an EOM (0x04). The SOM and EOM values
 * may also appear in application payload.
 * Payload length (L1:L0): octet length of application payload including any escape characters. L0
 * stands for bit0 to bit6, and L1 stands for bit7 to bit12 of the payload length.
 * Command ID: specifies types of payload
 * A: 1 if ACK required, 0 if no ACK is required. If A=1, then the receiver must send ACK upon a
 * successful validation of the frame. A frame requiring acknowledgement must be acknowledged
 * Murata SW Design
 * Murata Proprietary Page 11 of 101
 * before any other non-response frame may be transmitted, i.e., a command response is always permitted.
 * Checksum: sum of L0, A | L1 and command ID.
 */
class UARTFrame
{

private :
    char l0;
    char l1;

    bool needACK;

    CommandID commandid;

    Payload * payload;

    char checksum;

public :

    static const char SOM = 0x02;
    static const char EOM = 0x04;

    // length
    char GetL0();

    void SetL0(const int value);

    char GetL1();

    void SetL1(const int value);

    int GetPayloadLength();

    void SetPayloadLength(const int length);

    // ack
    bool GetACKRequired();

    void SetACKRequired(const bool ack);

    //command id
    CommandID GetCommandID();

    void SetCommandID(const CommandID id);

    void SetCommandID(const int value);

    // payload
    void SetPayload(Payload * payload);

    Payload * GetPayload();

    // checksum
    char GetChecksum();

    void SetChecksum(const int checksum);

    bool VerifyChecksum();
};
}

#endif