#include "UARTFrame.h"

using namespace SmartLabMuRata;

char UARTFrame::GetL0()
{
    return l0;
}

void UARTFrame::SetL0(const int value)
{
    l0 = value & 0x7F;
}

char UARTFrame::GetL1()
{
    return l1;
}

void UARTFrame::SetL1(const int value)
{
    l1 = value & 0x3F;

    if ((value & 0x40) == 0x40)
        needACK = true;
    else needACK = false;
}

int UARTFrame::GetPayloadLength()
{
    return (l1 << 7) | l0;
}

void UARTFrame::SetPayloadLength(const int length)
{
    SetL0(length);
    SetL1(length >> 7);
}

// ack
bool UARTFrame::GetACKRequired()
{
    return needACK;
}

void UARTFrame::SetACKRequired(const bool ack)
{
    needACK = ack;
}

//command id
CommandID UARTFrame::GetCommandID()
{
    return commandid;
}

void UARTFrame::SetCommandID(const CommandID id)
{
    SetCommandID ((int)id);
}

void UARTFrame::SetCommandID(const int value)
{
    commandid = (CommandID)(value & 0x7F);
}

// payload
void UARTFrame::SetPayload(Payload * payload)
{
    this->payload = payload;
    SetPayloadLength(payload->GetPosition());
    SetChecksum(l0 + (needACK ? l1 | 0x40 : l1) + commandid);
}

Payload * UARTFrame::GetPayload()
{
    return payload;
}

// checksum
char UARTFrame::GetChecksum()
{
    return checksum;
}

void UARTFrame::SetChecksum(const int checksum)
{
    this->checksum = checksum & 0x7F;
}

bool UARTFrame::VerifyChecksum()
{
    if (((l0 + (needACK ? l1 | 0x40 : l1) + commandid) & 0x7F) == checksum)
        return true;
    return false;
}