#include "WIFINetworkDetail.h"

using namespace SmartLabMuRata;

WIFINetworkDetail::WIFINetworkDetail() { }

WIFINetworkDetail::~WIFINetworkDetail() {}

WIFINetworkDetail::WIFINetworkDetail(const char * SSID, const SecurityMode securityMode, const BSSType networkType, const int rssi, const int maxDataRate)
    : WIFINetwork(SSID, securityMode)
{
    netType = networkType;
    this->rssi = rssi;
    this->maxDataRate = maxDataRate;
}

int8_t WIFINetworkDetail::GetRSSI()
{
    return rssi;
}

/// <summary>
/// Max Data Rate (Mbps)
/// </summary>
/// <returns></returns>
int WIFINetworkDetail::GetMaxDataRate()
{
    return maxDataRate;
}

BSSType WIFINetworkDetail::GetNetworkType()
{
    return netType;
}

WIFINetworkDetail * WIFINetworkDetail::SetRSSI(const int rssi)
{
    this->rssi = rssi;
    return this;
}

WIFINetworkDetail * WIFINetworkDetail::SetNetworkType(const BSSType networkType)
{
    netType = networkType;
    return this;
}

WIFINetworkDetail * WIFINetworkDetail::SetMaxDataRate(const int maxDataRate)
{
    this->maxDataRate = maxDataRate;
    return this;
}

WIFINetworkDetail * WIFINetworkDetail::SetSecurityKey(const char * SecurityKey)
{
    WIFINetwork::SetSecurityKey(SecurityKey);
    return this;
}

WIFINetworkDetail * WIFINetworkDetail::SetBSSID(const char * BSSID)
{
    WIFINetwork::SetBSSID(BSSID);
    return this;
}

WIFINetworkDetail * WIFINetworkDetail::SetSSID(const char * SSID)
{
    WIFINetwork::SetSSID(SSID);
    return this;
}

WIFINetworkDetail * WIFINetworkDetail::SetSecurityMode(const SecurityMode securityMode)
{
    WIFINetwork::SetSecurityMode(securityMode);
    return this;
}

WIFINetworkDetail * WIFINetworkDetail::SetChannel(const char channel)
{
    WIFINetwork::SetChannel(channel);
    return this;
}