#include "WIFINetwork.h"

using namespace SmartLabMuRata;

const char * WIFINetwork::GetSecurityKey()
{
    return key;
}

const char * WIFINetwork::GetBSSID()
{
    return bssid;
}

WIFINetwork::WIFINetwork()
{
    bssid = NULL;
    key = NULL;
}

WIFINetwork::WIFINetwork(const char * SSID, const SecurityMode securityMode, const char * securityKey)
    : WIFIInfo(SSID, securityMode)
{
    bssid = NULL;
    key = NULL;
    SetSecurityKey(securityKey);
}

WIFINetwork::~WIFINetwork()
{
    if (bssid != NULL)
        delete[] bssid;

    if (key != NULL)
        delete[] key;
}

WIFINetwork * WIFINetwork::SetSecurityKey(const char * SecurityKey)
{
    if (SecurityKey == NULL)
        return this;

    if (key != NULL)
        delete[] key;

    int length = strlen(SecurityKey) + 1;

    key = new char[length];
    memcpy(key, SecurityKey, length);
    return this;
}

WIFINetwork * WIFINetwork::SetBSSID(const char * BSSID)
{
    if (BSSID == NULL)
        return this;

    if (bssid != NULL)
        delete[] bssid;

    bssid = new char[6];
    memcpy(bssid, BSSID, 6);
    return this;
}

WIFINetwork * WIFINetwork::SetSSID(const char * SSID)
{
    WIFIInfo::SetSSID(SSID);
    return this;
}

WIFINetwork * WIFINetwork::SetSecurityMode(const SecurityMode securityMode)
{
    WIFIInfo::SetSecurityMode(securityMode);
    return this;
}

WIFINetwork * WIFINetwork::SetChannel(const char channel)
{
    WIFIInfo::SetChannel(channel);
    return this;
}