#include "WIFIInfo.h"

using namespace SmartLabMuRata;

const char * WIFIInfo::GetSSID()
{
    return ssid;
}

SecurityMode WIFIInfo::GetSecurityMode()
{
    return mode;
}

char WIFIInfo::GetChannel()
{
    return channel;
}

WIFIInfo::WIFIInfo()
{
    ssid = NULL;
}

WIFIInfo::WIFIInfo(const char * SSID, const SecurityMode securityMode)
{
    ssid = NULL;
    SetSSID(SSID)->SetSecurityMode(securityMode);
}


WIFIInfo::~WIFIInfo()
{
    if (ssid != NULL)
        delete[] ssid;
}


WIFIInfo * WIFIInfo::SetSSID(const char * SSID)
{
    if (SSID == NULL)
        return this;

    if (ssid != NULL)
        delete[] ssid;

    int length = strlen(SSID) + 1;
    ssid = new char[length];
    memcpy(ssid, SSID, length);
    return this;
}

WIFIInfo * WIFIInfo::SetSecurityMode(const SecurityMode securityMode)
{
    this->mode = securityMode;
    return this;
}

WIFIInfo * WIFIInfo::SetChannel(const char channel)
{
    this->channel = channel;
    return this;
}

const char * WIFIInfo::ToString()
{
    return ssid;
}