#include "InitializationResponse.h"

using namespace SmartLabMuRata;

InitializationResponse::InitializationResponse(Payload * payload)
    : Payload(payload)
{ }

SNICCode InitializationResponse::GetStatus()
{
    return (SNICCode)GetData()[2];
}

int InitializationResponse::GetDefaultReceiveBufferSize()
{
    return GetData()[3] << 8 | GetData()[4];
}

int InitializationResponse::GetMaximumUDPSupported()
{
    return GetData()[5];
}

int InitializationResponse::GetMaximumTCPSupported()
{
    return GetData()[6];
}