#ifndef SmartLab_MuRata_Response_HTTPResponse
#define SmartLab_MuRata_Response_HTTPResponse

#include "Payload.h"
#include <string>

using namespace std;

namespace SmartLabMuRata
{
class HTTPResponse: public Payload
{
private :
    int payloadOffset;
    int contentLength;
    int statusCode;
    string contentType;

public :
    HTTPResponse(Payload * payload);

    /// <summary>
    /// Present only if Status code is HTTP status code.
    /// </summary>
    /// <returns></returns>
    bool isMoreDataComing();

    /// <summary>
    /// Present only if Status code is HTTP status code.
    /// </summary>
    /// <returns></returns>
    int GetContentLength();

    /// <summary>
    /// Status code can be either SNIC status code (which is less than 100) listed in Table 18, or HTTP status code defined in HTTP spec 1.1 (which is bigger than 100).
    /// </summary>
    /// <returns></returns>
    int GetStatusCode();

    /// <summary>
    /// Present only if Status code is HTTP status code.
    /// </summary>
    /// <param name="index"></param>
    /// <returns></returns>
    char GetContent(int index);

    /// <summary>
    /// Present only if Status code is HTTP status code.
    /// </summary>
    /// <param name="index"></param>
    /// <returns></returns>
    const char * GetContent();

    /// <summary>
    /// Present only if Status code is HTTP status code.
    /// </summary>
    /// <returns></returns>
    string & GetContentType();

    /// <summary>
    /// Present only if Status code is HTTP status code.
    /// </summary>
    /// <returns></returns>
    int GetContentOffset();
};
}

#endif