#include "DHCPInfoResponse.h"

using namespace SmartLabMuRata;

DHCPInfoResponse::DHCPInfoResponse(Payload * payload)
    : Payload(payload)
{ }

SNICCode DHCPInfoResponse::GetStatus()
{
    return (SNICCode)GetData()[2];
}

const char * DHCPInfoResponse::GetLocalMAC()
{
    if (GetStatus() != SNIC_SUCCESS)
        return NULL;

    return GetData() + 3;
}

IPAddress DHCPInfoResponse::GetLocalIP()
{
    IPAddress ip;

    if (GetStatus() != SNIC_SUCCESS)
        return ip;

    ip.SetValue(GetData(), 9);
    return ip;
}

IPAddress DHCPInfoResponse::GetGatewayIP()
{
    IPAddress ip;

    if (GetStatus() != SNIC_SUCCESS)
        return ip;

    ip.SetValue(GetData(), 13);
    return ip;
}

IPAddress DHCPInfoResponse::GetSubnetMask()
{
    IPAddress ip;

    if (GetStatus() != SNIC_SUCCESS)
        return ip;

    ip.SetValue(GetData(), 17);
    return ip;
}

DHCPMode DHCPInfoResponse::GetDHCPMode()
{
    return (DHCPMode)GetData()[21];
}