#include "Payload.h"

using namespace SmartLabMuRata;

Payload::Payload()
{
    max = EXPANDSIZE;
    data = new char[EXPANDSIZE];
    position = 0;
}

Payload::Payload(Payload * payload)
{
    position = 0;
    max = 0;
    SetPayload(payload);
}

void Payload::SetPayload(Payload * payload)
{
    if (payload == NULL)
        return;

    this->data = payload->data;
    this->position = payload->position;
    this->max = payload->max;
}

char * Payload::GetData()
{
    return data;
}

ResponseFlag Payload::GetResponseFlag()
{
    if ((data[0] >> 7) == 0x01)
        return Response_Confirmation;
    else return Request_Indication;
}

void Payload::SetResponseFlag(const ResponseFlag flag)
{
    if (flag == Request_Indication)
        data[0] &= 0x7F;
    else data[0] |= 0x80;
}

SubCommandID Payload::GetSubCommandID()
{
    return (SubCommandID)(data[0] & 0x7F);
}

void Payload::SetSubCommandID(const SubCommandID id)
{
    SetSubCommandID((int)id);
}

void Payload::SetSubCommandID(const int value)
{
    data[0] = (data[0] & 0x80) | (value & 0x7F);
    position = 1;
}

char Payload::GetFrameID()
{
    return data[1];
}

void Payload::SetFrameID(const char frameID)
{
    data[1] = frameID;
    position = 2;
}

int Payload::GetPosition()
{
    return position;
}

void Payload::SetPosition(const int position)
{
    if (this->position > max)
        this->position = max;
    else this->position = position;
}

void Payload::Allocate(const int length)
{
    if (length <= 0)
        return;

    if (length > max) {
        delete[] data;
        data = new char[length];
    }

    Rewind();
}

void Payload::Rewind()
{
    position = 0;
}

void Payload::SetContent(const char value)
{
    if (position >= max) {
        max += EXPANDSIZE;
        char * temp = new char[max];
        memcpy(temp, data, position);
        delete[] data;
        data = temp;
    }

    data[position++] = value;
}

void Payload::SetContent(const char * value, const int offset, const int length)
{
    if (length <= 0)
        return;

    if (position + length >= max) {
        max += EXPANDSIZE * (1 + length / EXPANDSIZE);
        char * temp = new char[max];
        memcpy(temp, data, position);
        delete[] data;
        data = temp;
    }

    memcpy(data + position, value + offset, length);
    position += length;
}