#include "HTTPResponseIndication.h"

using namespace SmartLabMuRata;

HTTPResponseIndication::HTTPResponseIndication(Payload * payload)
    : Payload(payload)
{
    if (payload == NULL)
        return;
        
    contentLength = (GetData()[2] & 0x7F) << 8 | GetData()[3];
    GetData()[PAYLOAD_OFFSET + contentLength] = 0x00;
}

bool HTTPResponseIndication::isMoreDataComing()
{
    return (GetData()[2] >> 7) == 0x01 ? true : false;
}

int HTTPResponseIndication::GetContentLength()
{
    return contentLength;
}

char HTTPResponseIndication::GetContent(int index)
{
    return GetData()[index + PAYLOAD_OFFSET];
}

const char * HTTPResponseIndication::GetContent()
{
    return GetData() + PAYLOAD_OFFSET;
}

int HTTPResponseIndication::GetContentOffset()
{
    return PAYLOAD_OFFSET;
}