#include "SoftAPConfig.h"

using namespace SmartLabMuRata;

SoftAPConfig::SoftAPConfig(const State state, const char * SSID, const SecurityMode securityMode, const char * securityKey)
    : WIFINetwork(SSID, securityMode, securityKey)
{
    SetOnOffState(state);
}

SoftAPConfig::State SoftAPConfig::GetOnOffStatus()
{
    return state;
}

char SoftAPConfig::GetPersistency()
{
    return persistency ? 0x01 : 0x00;
}

SoftAPConfig * SoftAPConfig::SetOnOffState(const State onOff)
{
    state = onOff;
    return this;
}

SoftAPConfig * SoftAPConfig::SetPersistency(const bool persistency)
{
    this->persistency = persistency;
    return this;
}

SoftAPConfig * SoftAPConfig::SetSecurityKey(const char * SecurityKey)
{
    WIFINetwork::SetSecurityKey(SecurityKey);
    return this;
}

SoftAPConfig * SoftAPConfig::SetBSSID(const char * BSSID)
{
    WIFINetwork::SetBSSID(BSSID);
    return this;
}

SoftAPConfig * SoftAPConfig::SetSSID(const char * SSID)
{
    WIFINetwork::SetSSID(SSID);
    return this;
}

/// <summary>
/// WIFI_SECURITY_OPEN
/// WIFI_SECURITY_WPA_TKIP_PSK
/// WIFI_SECURITY_WPA2_AES_PSK
/// WIFI_SECURITY_WPA2_MIXED_PSK
/// supported
/// </summary>
/// <param name="securityMode"></param>
/// <returns></returns>
SoftAPConfig * SoftAPConfig::SetSecurityMode(const SecurityMode securityMode)
{
    WIFINetwork::SetSecurityMode(securityMode);
    return this;
}

SoftAPConfig * SoftAPConfig::SetChannel(const char  channel)
{
    WIFINetwork::SetChannel(channel);
    return this;
}