#ifndef SmartLab_MuRata_Config_DHCPConfig
#define SmartLab_MuRata_Config_DHCPConfig

#include "WIFIInterface.h"
#include "DHCPMode.h"
#include "IPAddress.h"

namespace SmartLabMuRata
{
class DHCPConfig
{
    /*
     * 0: interface is assigned the static IP, NetMask and Gateway IP. First IP and Last IP are not present. Any active DHCP client or server is stopped.
     * 1: STA interface uses DHCP to obtain the address. All subsequent fields are not present. STA DHCP client is started if necessary.
     * 2: only for AP interface. If the soft AP is not started or SNIC_INIT_REQ is not done, this command fails. Otherwise, this command stops the HTTP server, DNS server and DHCP server if configured, and restarts them with new parameters. It assigns IP for clients in range [First IP, Last IP] within the subnet mask. The AP itself is assigned the address within the same subnet specified by IP which must not be in the range of [First IP, Last IP]. The value of GTW IP and IP should be the same. If there are clients connected to the soft AP before this command, make sure the clients reconnect to the soft AP after this command.
     */

private :
    WIFIInterface _interface;
    DHCPMode mode;

    IPAddress * ip;
    IPAddress * mask;
    IPAddress * gateway;
    IPAddress * first;
    IPAddress * last;

public :

    DHCPConfig(const WIFIInterface wifiInterface, const DHCPMode mode);

    ~DHCPConfig();

    WIFIInterface GetInterface();

    DHCPMode GetDHCPMode();

    IPAddress * GetLocalIP();

    IPAddress * GetNetmask();

    IPAddress * GetGatewayIP();

    IPAddress * GetIPRangeFirst();

    IPAddress * GetIPRangeLast();

    DHCPConfig & SetInterface(const WIFIInterface wifiInterface);

    DHCPConfig & SetDHCPMode(const DHCPMode mode);

    DHCPConfig & SetLocalIP(char * ip);

    DHCPConfig & SetNetmask(char * netmask);

    DHCPConfig & SetGatewayIP(char * gateway);

    DHCPConfig & SetIPRange(char * first, char * last);
};
}

#endif