#include "IPAddress.h"

using namespace SmartLabMuRata;
IPAddress::IPAddress()
{}

IPAddress::IPAddress(const char * ipString)
{
    if (ipString == NULL)
        return;

    int size = strlen(ipString) + 1;
    char temp[size];

    memcpy(temp, ipString, size);

    int i = 0;
    char * pch = strtok (temp, ".");
    while (pch != NULL) {
        address[i++] = atoi(pch);
        pch = strtok (NULL, ".");

        if (i >= 4)
            break;
    }
}

void IPAddress::SetValue(const char * data, int offset)
{
    memcpy(address, data + offset, 4);
}

const char * IPAddress::GetValue()
{
    return address;
}
int IPAddress::GetValueLength()
{
    return 4;
}

const char * IPAddress::ToString()
{
    sprintf (ip, "%d.%d.%d.%d", address[0], address[1], address[2], address[3]);
    return ip;
}