#include "HTTPContent.h"

using namespace SmartLabMuRata;

const char HTTPContent::HEADER_SEPARATE[] = ": ";
const char HTTPContent::HEADER_TEMINATE[] = "\r\n";

HTTPContent::HTTPContent(const HTTPMethod method, const char * remoteHost,const int remotePort,const char * uri, const char timeout, const char * contentType)
{
    body = NULL;
    SetMethod(method)->SetRemoteHost(remoteHost)->SetRemotePort(remotePort)->SetURI(uri)->SetTimeout(timeout)->SetContentType(contentType);
}

HTTPContent::~HTTPContent()
{
    if (body != NULL)
        delete[] body;
}

HTTPMethod HTTPContent::GetMethod()
{
    return method;
}

HTTPContent * HTTPContent::SetMethod(const HTTPMethod method)
{
    this->method = method;
    return this;
}

char HTTPContent::GetTimeout()
{
    return timeout;
}

/// <summary>
/// Timeout is in seconds. If Timeout is 0, it means wait forever. A complete HTTP request will block other commands until either a response is received or timeout. So timeout value of 0 is not recommended. If timeout happens, the response status code would be SNIC_TIMEOUT. If it is chunked encoding in the response, the last chunk should be received before Timeout; otherwise, the connection is closed. If the HTTP request has more data to send (POST), it is not considered a complete HTTP request, and other commands are not blocked until the series of SNIC_HTTP_MORE_REQ are finished.
/// </summary>
/// <param name="timeout"></param>
/// <returns></returns>
HTTPContent * HTTPContent::SetTimeout(const char timeout)
{
    this->timeout = timeout;
    return this;
}

int HTTPContent::GetRemotePort()
{
    return remotePort;
}

HTTPContent * HTTPContent::SetRemotePort(const int port)
{
    this->remotePort = port;
    return this;
}

const char * HTTPContent::GetRemoteHost()
{
    return remoteHost.c_str();
}

HTTPContent * HTTPContent::SetRemoteHost(const char * host)
{
    remoteHost.assign(host);
    return this;
}

const char *  HTTPContent::GetURI()
{
    return uri.c_str();
}

HTTPContent * HTTPContent::SetURI(const char * uri)
{
    this->uri.assign(uri);
    return this;
}

const char * HTTPContent::GetContentType()
{
    return contentType.c_str();
}

HTTPContent * HTTPContent::SetContentType(const char * contentType)
{
    if (contentType == NULL)
        return this;

    this->contentType.assign(contentType);
    return this;
}

/*
const string * HTTPContent::GetOtherHeader(const string * key)
{
    if (otherHeaders.count(*key) > 0)
        return otherHeaders[*key];
    else return NULL;
}*/

HTTPContent * HTTPContent::SetOtherHeader(const char * key, const char * value)
{
    otherHeaders[key] = value;
    return this;
}

void HTTPContent::GetOtherHeaders(string * headers)
{
    for (map<const char *, const char *>::iterator it=otherHeaders.begin(); it!=otherHeaders.end(); ++it)
        headers->append(it->first).append(HEADER_SEPARATE).append(it->second).append(HEADER_TEMINATE);
}

const char * HTTPContent::GetBody()
{
    return body;
}

HTTPContent * HTTPContent::SetBody(char * body, int offset, int length)
{
    if (body == NULL)
        contentLength = 0;
    else
        contentLength = length - offset;

    if (this->body != NULL)
        delete[] this->body;

    this->body = new char[contentLength];
    memcpy(this->body, body + offset, contentLength);
    return this;
}

HTTPContent * HTTPContent::ClearBody()
{
    contentLength = 0;
    delete[] body;
    body = NULL;
    return this;
}

int HTTPContent::GetContentLength()
{
    return contentLength;
}