#include "WIFIStatusResponse.h"

using namespace SmartLabMuRata;

WIFIStatusResponse::WIFIStatusResponse(Payload * payload)
    : Payload(payload)
{ }

WIFIStatusCode WIFIStatusResponse::GetWiFiStatusCode()
{
    return (WIFIStatusCode)GetData()[2];
}

const char * WIFIStatusResponse::GetMACAddress()
{
    if (GetWiFiStatusCode() == WIFI_OFF)
        return NULL;
        
    return GetData() + 3;
}

const char * WIFIStatusResponse::GetSSID()
{
    WIFIStatusCode code = GetWiFiStatusCode();
    if (code == STA_JOINED || code == AP_STARTED)
        return GetData() + 9;

    return NULL;
}