#ifndef SmartLab_MuRata_Payload
#define SmartLab_MuRata_Payload

#include "mbed.h"

#include "ResponseFlag.h"
#include "SubCommandID.h"


namespace SmartLabMuRata
{
class Payload
{
private :

    static const int EXPANDSIZE = 1024;

    char * data;

    int position;
    
    int max;

public:
    Payload();

    Payload(Payload * payload);
    
    void SetPayload(Payload * payload);

    char * GetData();

    /// <summary>
    /// The first byte of the Payload of the command describes the specific operation to perform for the Command ID, and it contains the Response Flag and Sub-Command ID (RFSCID). The Payload may be a request (REQ) from the host to the module, a response (RSP) from the module to that request, an indication (IND) from the module to the host, and the optional confirmation (CFM) from the host for that indication.
    /// </summary>
    /// <returns></returns>
    ResponseFlag GetResponseFlag();

    void SetResponseFlag(const ResponseFlag flag);

    // sub command id
    SubCommandID GetSubCommandID();

    /// <summary>
    /// must call SetSubCommandID first then SetFrameID, and any other data afterwards
    /// </summary>
    void SetSubCommandID(const SubCommandID id) ;

    /// <summary>
    /// must call SetSubCommandID first then SetFrameID, and any other data afterwards
    /// </summary>
    void SetSubCommandID(const int value);

    // frame id
    char GetFrameID();

    /// <summary>
    /// must call SetSubCommandID first then SetFrameID, and any other data afterwards
    /// </summary>
    void SetFrameID(const char frameID);

    // content
    int GetPosition();

    void SetPosition(const int position);

    void Allocate(const int length);

    void Rewind();

    void SetContent(const char value);

    void SetContent(const char * value, const int offset, const int length);
};
}

#endif
