#ifndef SmartLab_MuRata_Indication_UDPReceivedIndication
#define SmartLab_MuRata_Indication_UDPReceivedIndication

#include "Payload.h"
#include "IPAddress.h"

namespace SmartLabMuRata
{
/// <summary>
/// This event is generated when a UDP server (in unconnected mode) receives a packet.
/// </summary>
class UDPReceivedIndication : public Payload
{
private :
    int receiveLength;

public :
    static const int PAYLOAD_OFFSET = 11;

    UDPReceivedIndication(Payload * payload);

    char GetServerSocketID();

    IPAddress GetRemoteIP();

    int GetRemotePort();

    int GetPayloadLength();

    char GetPayload(int index);

    const char * GetPayload();

    /// <summary>
    /// Get the start index of the payload
    /// </summary>
    /// <returns></returns>
    int GetPayloadOffset();
};
}

#endif