#include "SocketReceiveInidcation.h"

using namespace SmartLabMuRata;

SocketReceiveInidcation::SocketReceiveInidcation(Payload * payload)
    : Payload(payload)
{
    if (payload == NULL)
        return;
        
    receiveLength = GetData()[3] << 8 | GetData()[4];
}

char SocketReceiveInidcation::GetServerSocketID()
{
    return GetData()[2];
}

int SocketReceiveInidcation::GetPayloadLength()
{
    return receiveLength;
}

char SocketReceiveInidcation::GetPayload(int index)
{
    return GetData()[index + PAYLOAD_OFFSET];
}

const char * SocketReceiveInidcation::GetPayload()
{
    return GetData() + PAYLOAD_OFFSET;
}

int SocketReceiveInidcation::GetPayloadOffset()
{
    return PAYLOAD_OFFSET;
}
