#include "UARTConfig.h"

using namespace SmartLabMuRata;

const char * UARTConfig::GetValue()
{
    return value;
}

int UARTConfig::GetValueLength()
{
    return 6;
}

UARTConfig::UARTConfig(const FlowControl flowControl, const Parity parity, const StopBits StopBits, const BaudRate baudRate)
{
    SetFlowControl(flowControl)->SetParity(parity)->SetStopBits(StopBits)->SetBaudRate(baudRate);
}

UARTConfig * UARTConfig::SetFlowControl(const FlowControl flowControl)
{
    value[1] = value[1] & 0xDF | flowControl;
    return this;
}

UARTConfig * UARTConfig::SetParity(const Parity parity)
{
    value[1] = value[1] & 0x3F | parity;
    return this;
}

UARTConfig * UARTConfig::SetStopBits(const StopBits stop)
{
    value[1] = value[1] & 0xFC | stop;
    return this;
}

UARTConfig * UARTConfig::SetBaudRate(const BaudRate baudRate)
{
    value[2] = baudRate >> 24;
    value[3] = baudRate >> 16;
    value[4] = baudRate >> 8;
    value[5] = baudRate;
    return this;
}