#ifndef SmartLab_MuRata_Config_SoftAPConfig
#define SmartLab_MuRata_Config_SoftAPConfig

#include "WIFINetwork.h"

namespace SmartLabMuRata
{
/*
* OnOff = 0 indicates AP is to be turned off. The rest of the parameters are ignored.
* BSSID is not required
* !!! cannot be WEP and WIFI_SECURITY_WPA_AES_PSK !!!
*/
class SoftAPConfig : public WIFINetwork
{
public :
    enum State {
        /**
        * indicates AP is to be turned off. The rest of the parameters are ignored.
        */
        OFF = 0x00,

        /**
        * indicates turning on soft AP using existing NVM parameters.
        */
        ON_NVM = 0x01,

        /**
        * indicates turning on AP with the parameters provided. If the soft AP is already on, it is first turned off.
        */
        ON_PARAMETERS = 0x02,
    };

    SoftAPConfig(State state, const char * SSID = NULL, const SecurityMode securityMode = WIFI_SECURITY_OPEN, const char * securityKey = NULL);

    State GetOnOffStatus();

    char GetPersistency();

    /**
    * OFF
    * ON_NVM
    * ON_PARAMETERS
    */
    SoftAPConfig * SetOnOffState(const State onOff);

    SoftAPConfig * SetPersistency(const bool persistency);

    virtual SoftAPConfig * SetSecurityKey(const char * SecurityKey);

    virtual SoftAPConfig * SetBSSID(const char * BSSID);

    virtual SoftAPConfig * SetSSID(const char * SSID);

    /**
    * Supported values :
    * WIFI_SECURITY_OPEN
    * WIFI_SECURITY_WPA_TKIP_PSK
    * WIFI_SECURITY_WPA2_AES_PSK
    * WIFI_SECURITY_WPA2_MIXED_PSK
    */
    virtual SoftAPConfig * SetSecurityMode(const SecurityMode securityMode);

    virtual SoftAPConfig * SetChannel(const char channel);

private :
    State state;

    /**
    * Persistency=1 indicates the soft AP’s on/off state and parameters (if OnOff = 2) will be saved in NVM.
    * For example, if OnOff =0 and Persistency=1, the soft AP will not be turned on after a reset.
    */
    bool persistency;
};
}

#endif