#include "DHCPConfig.h"

using namespace SmartLabMuRata;

DHCPConfig::DHCPConfig(const WIFIInterface wifiInterface, const DHCPMode mode)
{
    ip = NULL;
    mask = NULL;
    gateway = NULL;
    first = NULL;
    last = NULL;
    SetDHCPMode(mode).SetInterface(wifiInterface);
}

DHCPConfig::~DHCPConfig()
{
    delete ip;
    delete mask;
    delete gateway;
    delete first;
    delete last;
}

WIFIInterface DHCPConfig::GetInterface()
{
    return _interface;
}

DHCPMode DHCPConfig::GetDHCPMode()
{
    return mode;
}

IPAddress * DHCPConfig::GetLocalIP()
{
    return ip;
}

IPAddress * DHCPConfig::GetNetmask()
{
    return mask;
}

IPAddress * DHCPConfig::GetGatewayIP()
{
    return gateway;
}

IPAddress * DHCPConfig::GetIPRangeFirst()
{
    return first;
}

IPAddress * DHCPConfig::GetIPRangeLast()
{
    return last;
}

DHCPConfig & DHCPConfig::SetInterface(const WIFIInterface wifiInterface)
{
    _interface = wifiInterface;
    return *this;
}

DHCPConfig & DHCPConfig::SetDHCPMode(const DHCPMode mode)
{
    this->mode = mode;
    return *this;
}

DHCPConfig & DHCPConfig::SetLocalIP(char * ip)
{
    this->ip = new IPAddress(ip);
    return *this;
}

DHCPConfig & DHCPConfig::SetNetmask(char * netmask)
{
    mask = new IPAddress(netmask);
    return *this;
}

DHCPConfig & DHCPConfig::SetGatewayIP(char * gateway)
{
    this->gateway = new IPAddress(gateway);
    return *this;
}

DHCPConfig & DHCPConfig::SetIPRange(char * first, char * last)
{
    this->first = new IPAddress(first);
    this->last = new IPAddress(last);
    return *this;
}