#ifndef SmartLab_MuRata_Type_WIFINetworkDetail
#define SmartLab_MuRata_Type_WIFINetworkDetail

#include "WIFINetwork.h"
#include "BSSType.h"

namespace SmartLabMuRata
{
class WIFINetworkDetail : public WIFINetwork
{
private:
    int8_t rssi;
    BSSType netType;
    // Max Data Rate (Mbps)
    int maxDataRate;

public :
    WIFINetworkDetail();
    
    virtual ~WIFINetworkDetail();

    WIFINetworkDetail(const char * SSID, const SecurityMode securityMode, const BSSType networkType, const int rssi, const int maxDataRate);

    int8_t GetRSSI();

    /// <summary>
    /// Max Data Rate (Mbps)
    /// </summary>
    /// <returns></returns>
    int GetMaxDataRate();

    BSSType GetNetworkType();

    WIFINetworkDetail * SetRSSI(const int rssi);

    WIFINetworkDetail * SetNetworkType(const BSSType networkType) ;

    WIFINetworkDetail * SetMaxDataRate(const int maxDataRate);

    virtual WIFINetworkDetail * SetSecurityKey(const char * SecurityKey);

    virtual WIFINetworkDetail * SetBSSID(const char * BSSID);

    virtual WIFINetworkDetail * SetSSID(const char * SSID);

    virtual WIFINetworkDetail * SetSecurityMode(const SecurityMode securityMode);

    virtual WIFINetworkDetail * SetChannel(const char channel);

};
}

#endif